/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.util.TagUtils;
import org.nrg.dcm.edit.AttributeVRMismatchException;
import org.nrg.dcm.edit.DicomUtils;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleTagValue
implements Value {
    private final int tag;

    public SingleTagValue(int tag) {
        this.tag = tag;
    }

    public SingleTagValue(Integer tag) {
        this((int)tag);
    }

    @Override
    public SortedSet<Integer> getTags() {
        return ImmutableSortedSet.of((Comparable)Integer.valueOf(this.tag));
    }

    @Override
    public Set<Variable> getVariables() {
        return Collections.emptySet();
    }

    @Override
    public String on(DicomObject o) throws ScriptEvaluationException {
        try {
            return DicomUtils.getString(o, this.tag);
        }
        catch (AttributeVRMismatchException e) {
            throw new ScriptEvaluationException(e);
        }
    }

    @Override
    public String on(Map<Integer, String> m) {
        return m.get(this.tag);
    }

    @Override
    public void replace(Variable _) {
    }

    public boolean equals(Object o) {
        return o instanceof SingleTagValue && this.tag == ((SingleTagValue)o).tag;
    }

    public int hashCode() {
        return this.tag;
    }

    public String toString() {
        return "value-of" + TagUtils.toString((int)this.tag);
    }
}

