/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.edit.Action;
import org.nrg.dcm.edit.AttributeException;
import org.nrg.dcm.edit.Constraint;
import org.nrg.dcm.edit.Operation;
import org.nrg.dcm.edit.ScriptEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement {
    private final Constraint c;
    private final Operation op;

    Statement(Operation a) {
        this(null, a);
    }

    public Statement(Constraint c, Operation a) {
        this.op = a;
        this.c = c;
    }

    public int getTopTag() {
        TreeSet tags = Sets.newTreeSet();
        if (null != this.c) {
            tags.addAll(this.c.getTags());
        }
        tags.add(this.op.getTopTag());
        return (Integer)tags.last();
    }

    public boolean isConstrained() {
        return null != this.c;
    }

    public boolean matchesConstraint(File f, DicomObject o) throws ScriptEvaluationException {
        return null == this.c || this.c.matches(f, o);
    }

    public Operation getOperation() {
        return this.op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" ");
        if (this.c != null) {
            sb.append(this.c).append(" => ");
        }
        sb.append(this.op);
        return sb.toString();
    }

    public static List<Operation> getOperations(Iterable<Statement> statements, File f, DicomObject o) throws IOException, ScriptEvaluationException {
        ArrayList ops = Lists.newArrayList();
        for (Statement s : statements) {
            Operation op = s.getOperation();
            if (null != op && s.isConstrained()) {
                o = DicomUtils.read((File)f);
                if (!s.matchesConstraint(f, o)) continue;
                ops.add(op);
                continue;
            }
            ops.add(op);
        }
        return ops;
    }

    public static List<Operation> getOperations(Iterable<Statement> s, File f) throws IOException, ScriptEvaluationException {
        return Statement.getOperations(s, f, null);
    }

    public static List<Action> getActions(Iterable<Statement> statements, File f, DicomObject o) throws AttributeException, ScriptEvaluationException {
        ArrayList actions = Lists.newArrayList();
        for (Statement s : statements) {
            Action action;
            Operation operation;
            if (!s.matchesConstraint(f, o) || null == (operation = s.getOperation()) || null == (action = operation.makeAction(o))) continue;
            actions.add(action);
        }
        return actions;
    }
}

