/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubstringValue
implements Value {
    private Value base;
    private final int beginIndex;
    private final int endIndex;

    public SubstringValue(Value base, int beginIndex, int endIndex) {
        this.base = base;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public SubstringValue(Value base, Integer beginIndex, Integer endIndex) {
        this(base, (int)beginIndex, (int)endIndex);
    }

    @Override
    public SortedSet<Integer> getTags() {
        return this.base.getTags();
    }

    @Override
    public Set<Variable> getVariables() {
        return this.base.getVariables();
    }

    private String substring(String s) throws ScriptEvaluationException {
        if (null == s) {
            return null;
        }
        try {
            return s.substring(this.beginIndex, this.endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ScriptEvaluationException("index out of bounds", e);
        }
    }

    @Override
    public String on(DicomObject o) throws ScriptEvaluationException {
        return this.substring(this.base.on(o));
    }

    @Override
    public String on(Map<Integer, String> m) throws ScriptEvaluationException {
        return this.substring(this.base.on(m));
    }

    @Override
    public void replace(Variable v) {
        this.base.replace(v);
    }
}

