/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableValue
implements Value {
    private final Logger logger = LoggerFactory.getLogger(VariableValue.class);
    private final SortedSet<Integer> EMPTY = ImmutableSortedSet.of();
    private Variable variable;

    public VariableValue(Variable variable) {
        this.variable = variable;
    }

    @Override
    public SortedSet<Integer> getTags() {
        return this.EMPTY;
    }

    @Override
    public Set<Variable> getVariables() {
        return Collections.singleton(this.variable);
    }

    @Override
    public String on(DicomObject o) throws ScriptEvaluationException {
        this.logger.trace("evaluating " + this);
        String v = this.variable.getValue();
        this.logger.trace("primary value = " + v);
        if (null == v) {
            Value initial = this.variable.getInitialValue();
            this.logger.trace("initial value = " + initial);
            return null == initial ? null : initial.on(o);
        }
        return v;
    }

    @Override
    public String on(Map<Integer, String> m) throws ScriptEvaluationException {
        String v = this.variable.getValue();
        if (null == v) {
            Value initial = this.variable.getInitialValue();
            return null == initial ? null : initial.on(m);
        }
        return v;
    }

    @Override
    public void replace(Variable v) {
        if (v.equals(this.variable)) {
            this.variable = v;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("(").append(this.variable).append(")");
        return sb.toString();
    }
}

