/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit.fn;

import com.fasterxml.uuid.Generators;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashUID
implements ScriptFunction {
    public static final String name = "hashUID";
    public static final String UUID_ROOT = "2.25";

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        if (args.isEmpty()) {
            throw new ScriptEvaluationException("usage: hashUID[string-to-hash {, optional algorithm-name} ]");
        }
        final Value sv = args.get(0);
        return new Value(){

            @Override
            public Set<Variable> getVariables() {
                return sv.getVariables();
            }

            @Override
            public SortedSet<Integer> getTags() {
                return sv.getTags();
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                try {
                    String v = sv.on(o);
                    return null == v ? null : HashUID.toUID(HashUID.toUUID(v));
                }
                catch (ScriptEvaluationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new ScriptEvaluationException(t);
                }
            }

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                try {
                    String v = sv.on(m);
                    return null == v ? null : HashUID.toUID(HashUID.toUUID(v));
                }
                catch (ScriptEvaluationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new ScriptEvaluationException(t);
                }
            }

            @Override
            public void replace(Variable v) {
                sv.replace(v);
            }
        };
    }

    private static String toUID(UUID uuid) {
        byte[] b17 = new byte[17];
        HashUID.fill(b17, 1, uuid.getMostSignificantBits());
        HashUID.fill(b17, 9, uuid.getLeastSignificantBits());
        return new StringBuilder(64).append(UUID_ROOT).append('.').append(new BigInteger(b17)).toString();
    }

    private static void fill(byte[] bb, int off, long val) {
        int i = off;
        for (int shift = 56; shift >= 0; shift -= 8) {
            bb[i] = (byte)(val >>> shift);
            ++i;
        }
    }

    private static UUID toUUID(String s) {
        return Generators.nameBasedGenerator().generate(s.getBytes());
    }
}

