/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit.fn;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Replace
implements ScriptFunction {
    public static final String name = "replace";

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        Value post;
        Value pre;
        Value original;
        try {
            original = args.get(0);
            pre = args.get(1);
            post = args.get(2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptEvaluationException("replace takes three arguments [original, pre, post]", e);
        }
        return new Value(){

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                return original.on(m).replace(pre.on(m), post.on(m));
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                return original.on(o).replace(pre.on(o), post.on(o));
            }

            @Override
            public Set<Variable> getVariables() {
                LinkedHashSet variables = Sets.newLinkedHashSet();
                variables.addAll(original.getVariables());
                variables.addAll(pre.getVariables());
                variables.addAll(post.getVariables());
                return variables;
            }

            @Override
            public SortedSet<Integer> getTags() {
                TreeSet tags = Sets.newTreeSet();
                tags.addAll(original.getTags());
                tags.addAll(pre.getTags());
                tags.addAll(post.getTags());
                return tags;
            }

            @Override
            public void replace(Variable v) {
                original.replace(v);
                pre.replace(v);
                post.replace(v);
            }
        };
    }
}

