/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.nrg.util.CheckedExceptionFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCachedFileProduct<T, E extends IOException>
implements CheckedExceptionFunction<File, T, E> {
    private final Map<File, CacheEntry<T>> cache;
    private final CheckedExceptionFunction<File, T, E> product;

    public MapCachedFileProduct(Map<File, CacheEntry<T>> m, CheckedExceptionFunction<File, T, E> product) {
        this.cache = m;
        this.product = product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T apply(File f) throws E {
        CacheEntry<T> ce = this.cache.get(f);
        if (null == ce) {
            this.cache.put(f, new CacheEntry(this.product.apply(f), f));
        } else {
            Map<File, CacheEntry<T>> map = this.cache;
            synchronized (map) {
                long lm = f.lastModified();
                if (lm > ((CacheEntry)ce).lastModified) {
                    this.cache.put(f, new CacheEntry(this.product.apply(f), f));
                }
            }
        }
        return (T)((CacheEntry)this.cache.get(f)).t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheEntry<T> {
        private final T t;
        private final long lastModified;

        private CacheEntry(T t, File f) {
            this.t = t;
            this.lastModified = f.lastModified();
        }
    }
}

