/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

public class Base64 {
    private static final String base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int splitLinesAt = 76;

    public static String encode(String string) {
        byte[] stringArray;
        StringBuilder encoded = new StringBuilder();
        try {
            stringArray = string.getBytes("UTF-8");
        }
        catch (Exception ignored) {
            stringArray = string.getBytes();
        }
        int paddingCount = (3 - stringArray.length % 3) % 3;
        stringArray = Base64.zeroPad(stringArray.length + paddingCount, stringArray);
        for (int i = 0; i < stringArray.length; i += 3) {
            int j = (stringArray[i] << 16) + (stringArray[i + 1] << 8) + stringArray[i + 2];
            encoded.append(base64code.charAt(j >> 18 & 0x3F));
            encoded.append(base64code.charAt(j >> 12 & 0x3F));
            encoded.append(base64code.charAt(j >> 6 & 0x3F));
            encoded.append(base64code.charAt(j & 0x3F));
        }
        return Base64.splitLines(encoded.substring(0, encoded.length() - paddingCount) + "==".substring(0, paddingCount));
    }

    public static String splitLines(String string) {
        StringBuilder lines = new StringBuilder();
        lines.append(string.substring(0, Math.min(string.length(), 76)));
        for (int i = 76; i < string.length(); i += 76) {
            lines.append("\r\n");
            lines.append(string.substring(i, Math.min(string.length(), i + 76)));
        }
        return lines.toString();
    }

    public static byte[] zeroPad(int length, byte[] bytes) {
        byte[] padded = new byte[length];
        System.arraycopy(bytes, 0, padded, 0, bytes.length);
        return padded;
    }
}

