/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.nrg.util.Base64;
import org.nrg.util.IHttpClient;

public class HttpClient
implements IHttpClient {
    private static final String AUTHORIZATION_HEADER = "Authorization";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(URL url) throws IOException {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (ClassCastException e) {
            throw new IOException("unable to make HTTP/HTTPS connection to URL " + url);
        }
        if (url.getUserInfo() != null) {
            StringBuilder authHeader = new StringBuilder("Basic ");
            authHeader.append(Base64.encode(url.getUserInfo()));
            connection.setRequestProperty(AUTHORIZATION_HEADER, authHeader.toString());
        }
        StringBuilder text = new StringBuilder();
        connection.connect();
        try {
            if (200 != connection.getResponseCode()) {
                throw new IOException("request failed: " + connection.getResponseCode() + " " + connection.getResponseMessage());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = reader.readLine();
            while (null != line) {
                text.append(line);
                line = reader.readLine();
            }
            reader.close();
        }
        finally {
            connection.disconnect();
        }
        return text.toString();
    }
}

