/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Line;
import ij.gui.ShapeRoi;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class Arrow
extends Line {
    public static final String STYLE_KEY = "arrow.style";
    public static final String WIDTH_KEY = "arrow.width";
    public static final String SIZE_KEY = "arrow.size";
    public static final String DOUBLE_HEADED_KEY = "arrow.double";
    public static final int FILLED = 0;
    public static final int NOTCHED = 1;
    public static final int OPEN = 2;
    public static final int HEADLESS = 3;
    public static final String[] styles = new String[]{"Filled", "Notched", "Open", "Headless"};
    private static int defaultStyle = (int)Prefs.get("arrow.style", 0.0);
    private static float defaultWidth = (float)Prefs.get("arrow.width", 2.0);
    private static double defaultHeadSize = (int)Prefs.get("arrow.size", 10.0);
    private static boolean defaultDoubleHeaded = Prefs.get("arrow.double", false);
    private int style;
    private double headSize = 10.0;
    private boolean doubleHeaded;

    public Arrow(double ox1, double oy1, double ox2, double oy2) {
        super(ox1, oy1, ox2, oy2);
        this.setStrokeWidth(2.0f);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
    }

    public Arrow(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.setStrokeWidth(defaultWidth);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
    }

    public void draw(Graphics g) {
        if (this.ic == null) {
            return;
        }
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        g.setColor(color);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        int sx1 = this.ic.screenXD(this.x1d);
        int sy1 = this.ic.screenYD(this.y1d);
        int sx2 = this.ic.screenXD(this.x2d);
        int sy2 = this.ic.screenYD(this.y2d);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        this.drawArrow((Graphics2D)g, null, sx1, sy1, sx2, sy2);
        if (this.doubleHeaded) {
            this.drawArrow((Graphics2D)g, null, sx2, sy2, sx1, sy1);
        }
        if (this.state != 0 && !this.overlay) {
            int size2 = 2;
            this.handleColor = Color.white;
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.drawHandle(g, sx2 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawArrow(Graphics2D g, ImageProcessor ip, double x1, double y1, double x2, double y2) {
        double mag = ip == null ? this.ic.getMagnification() : 1.0;
        double arrowWidth = this.getStrokeWidth();
        if (ip == null) {
            g.setStroke(new BasicStroke((float)(arrowWidth * mag)));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double size = 8.0 + 10.0 * arrowWidth * mag * 0.5;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double ra = Math.sqrt(dx * dx + dy * dy);
        double x3 = x2 - (dx /= ra) * (size *= this.headSize / 10.0);
        double y3 = y2 - (dy /= ra) * size;
        double ratio = this.style == 2 ? 0.45 : 0.35;
        double r = ratio * size;
        double x4 = Math.round(x3 + dy * r);
        double y4 = Math.round(y3 - dx * r);
        double x5 = Math.round(x3 - dy * r);
        double y5 = Math.round(y3 + dx * r);
        double x6 = x2 - dx * 0.85 * size;
        double y6 = y2 - dy * 0.85 * size;
        if (ra > size || this.style == 3) {
            double scale;
            double d = scale = this.style == 2 ? 0.25 : 0.75;
            if (this.style == 2) {
                size /= 3.0;
            }
            double yadjust = scale * dy * size;
            if (this.style == 3) {
                scale = 0.0;
            }
            int xx1 = this.doubleHeaded || this.style == 3 ? (int)(x1 + scale * dx * size) : (int)x1;
            int yy1 = this.doubleHeaded || this.style == 3 ? (int)(y1 + scale * dy * size) : (int)y1;
            int xx2 = (int)(x2 - scale * dx * size);
            int yy2 = (int)(y2 - scale * dy * size);
            if (ip != null) {
                ip.drawLine(xx1, yy1, xx2, yy2);
            } else {
                g.drawLine(xx1, yy1, xx2, yy2);
            }
        }
        if (this.style == 3) {
            return;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)x4, (float)y4);
        path.lineTo((float)x2, (float)y2);
        path.lineTo((float)x5, (float)y5);
        if (this.style != 2) {
            if (this.style == 1) {
                path.lineTo((float)x6, (float)y6);
            }
            path.lineTo((float)x4, (float)y4);
        }
        if (ip != null) {
            if (this.style == 2) {
                ip.moveTo((int)x4, (int)y4);
                ip.lineTo((int)x2, (int)y2);
                ip.lineTo((int)x5, (int)y5);
            } else {
                ip.fill(new ShapeRoi(path));
            }
        } else if (this.style == 2) {
            if (x1 != x2 || y1 != y2) {
                g.draw(path);
            }
        } else {
            g.fill(path);
        }
    }

    public void drawPixels(ImageProcessor ip) {
        int width = Math.round(this.getStrokeWidth());
        ip.setLineWidth(width);
        this.drawArrow(null, ip, this.x1, this.y1, this.x2, this.y2);
        if (this.doubleHeaded) {
            this.drawArrow(null, ip, this.x2, this.y2, this.x1, this.y1);
        }
    }

    protected int clipRectMargin() {
        double mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        double arrowWidth = this.getStrokeWidth();
        double size = 8.0 + 10.0 * arrowWidth * mag * 0.5;
        return (int)Math.max(size * 2.0, this.headSize);
    }

    public boolean isDrawingTool() {
        return true;
    }

    public static void setDefaultWidth(double width) {
        defaultWidth = (float)width;
    }

    public static double getDefaultWidth() {
        return defaultWidth;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public static void setDefaultStyle(int style) {
        defaultStyle = style;
    }

    public static int getDefaultStyle() {
        return defaultStyle;
    }

    public void setHeadSize(double headSize) {
        this.headSize = headSize;
    }

    public double getHeadSize() {
        return this.headSize;
    }

    public static void setDefaultHeadSize(double size) {
        defaultHeadSize = size;
    }

    public static double getDefaultHeadSize() {
        return defaultHeadSize;
    }

    public void setDoubleHeaded(boolean b) {
        this.doubleHeaded = b;
    }

    public boolean getDoubleHeaded() {
        return this.doubleHeaded;
    }

    public static void setDefaultDoubleHeaded(boolean b) {
        defaultDoubleHeaded = b;
    }

    public static boolean getDefaultDoubleHeaded() {
        return defaultDoubleHeaded;
    }

    static {
        if (defaultStyle < 0 || defaultStyle > 3) {
            defaultStyle = 0;
        }
    }
}

