/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Roi;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Vector;

public class Overlay {
    private Vector list = new Vector();
    private boolean label;

    public Overlay() {
    }

    public Overlay(Roi roi) {
        this.list.add(roi);
    }

    public void add(Roi roi) {
        this.list.add(roi);
    }

    public void addElement(Roi roi) {
        this.list.add(roi);
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public void remove(Roi roi) {
        this.list.remove(roi);
    }

    public void clear() {
        this.list.clear();
    }

    public Roi get(int index) {
        return (Roi)this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public Roi[] toArray() {
        Roi[] array = new Roi[this.list.size()];
        return this.list.toArray(array);
    }

    public void setStrokeColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setStrokeColor(color);
        }
    }

    public void setFillColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setFillColor(color);
        }
    }

    public void translate(int dx, int dy) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            Rectangle r = rois[i].getBounds();
            rois[i].setLocation(r.x + dx, r.y + dy);
        }
    }

    public Overlay duplicate() {
        Roi[] rois = this.toArray();
        Overlay overlay2 = new Overlay();
        for (int i = 0; i < rois.length; ++i) {
            overlay2.add((Roi)rois[i].clone());
        }
        overlay2.drawLabels(this.label);
        return overlay2;
    }

    public String toString() {
        return this.list.toString();
    }

    public void drawLabels(boolean b) {
        this.label = b;
    }

    public void temporarilyHide(int index1, int index2) {
        int n = this.list.size();
        if (index1 < 0 || index2 >= n || index2 < index1) {
            return;
        }
        for (int i = index1; i <= index2; ++i) {
            this.get(i).temporarilyHide();
        }
    }

    boolean getDrawLabels() {
        return this.label;
    }

    void setVector(Vector v) {
        this.list = v;
    }

    Vector getVector() {
        return this.list;
    }
}

