/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;

public class MemoryMonitor
implements PlugIn {
    int width = 200;
    int height = 75;
    long fps;
    long startTime;
    long elapsedTime;
    ImageProcessor ip;
    int frames;
    ImageCanvas ic;
    double[] mem;
    int index;
    long value;
    double max = 1.4794752E7;
    long maxMemory = IJ.maxMemory();

    public void run(String arg) {
        if (Interpreter.isBatchMode()) {
            return;
        }
        if (IJ.altKeyDown()) {
            this.width = 640;
            this.height = 480;
        }
        this.ip = new ByteProcessor(this.width, this.height, new byte[this.width * this.height], null);
        this.ip.setColor(Color.white);
        this.ip.fill();
        this.ip.setColor(Color.black);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.setAntialiasedText(true);
        this.ip.snapshot();
        ImagePlus imp = new ImagePlus("Memory", this.ip);
        ImageWindow.centerNextImage();
        imp.show();
        imp.lock();
        ImageWindow win = imp.getWindow();
        this.ic = win.getCanvas();
        this.mem = new double[this.width + 1];
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        win.running = true;
        while (win.running) {
            this.updatePixels();
            this.showValue();
            imp.updateAndDraw();
            if (this.width == 640) {
                Thread.yield();
            } else {
                IJ.wait(100);
            }
            ++this.frames;
        }
        imp.unlock();
    }

    void showValue() {
        double value2 = (double)this.value / 1048576.0;
        String s = IJ.d2s(value2, value2 > 50.0 ? 0 : 2) + "MB";
        if (this.maxMemory > 0L) {
            double percent = this.value * 100L / this.maxMemory;
            s = s + " (" + (percent < 1.0 ? "<1" : IJ.d2s(percent, 0)) + "%)";
        }
        if (this.width == 640) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.elapsedTime > 0L) {
                double scale = this.ic.getMagnification();
                this.fps = (long)(this.frames * 10000) / this.elapsedTime;
                s = s + ", " + this.fps / 10L + "." + this.fps % 10L + " fps";
            }
        }
        this.ip.moveTo(2, 15);
        this.ip.drawString(s);
    }

    void updatePixels() {
        double used = IJ.currentMemory();
        if (this.frames % 10 == 0) {
            this.value = (long)used;
        }
        if (used > 0.9 * this.max) {
            this.max *= 2.0;
        }
        this.mem[this.index++] = used;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        this.ip.setLineWidth(1);
        this.ip.reset();
        int index2 = this.index + 1;
        if (index2 == this.mem.length) {
            index2 = 0;
        }
        double scale = (double)this.height / this.max;
        this.ip.moveTo(0, this.height - (int)(this.mem[index2] * scale));
        for (int x = 1; x < this.width; ++x) {
            if (++index2 == this.mem.length) {
                index2 = 0;
            }
            this.ip.lineTo(x, this.height - (int)(this.mem[index2] * scale));
        }
    }
}

