/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;

class PlugInExecuter
implements Runnable {
    private String plugin;
    private Thread thread;

    PlugInExecuter(String plugin) {
        this.plugin = plugin;
        this.thread = new Thread((Runnable)this, plugin);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        try {
            IJ.resetEscape();
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                ij.runUserPlugIn(this.plugin, this.plugin, "", true);
            }
        }
        catch (Throwable e) {
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.unlock();
            }
            String msg = e.getMessage();
            if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                return;
            }
            IJ.handleException(e);
        }
    }
}

