/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class FFTFilter
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private String arg;
    private static int filterIndex = 1;
    private FHT fht;
    private int slice;
    private int stackSize = 1;
    private static double filterLargeDia = 40.0;
    private static double filterSmallDia = 3.0;
    private static int choiceIndex = 0;
    private static String[] choices = new String[]{"None", "Horizontal", "Vertical"};
    private static String choiceDia = choices[0];
    private static double toleranceDia = 5.0;
    private static boolean doScalingDia = true;
    private static boolean saturateDia = true;
    private static boolean displayFilter;
    private static boolean processStack;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        this.stackSize = imp.getStackSize();
        this.fht = (FHT)imp.getProperty("FHT");
        if (this.fht != null) {
            IJ.error("FFT Filter", "Spatial domain image required");
            return 4096;
        }
        if (!this.showBandpassDialog(imp)) {
            return 4096;
        }
        return processStack ? 32831 : 31;
    }

    public void run(ImageProcessor ip) {
        ++this.slice;
        this.filter(ip);
    }

    void filter(ImageProcessor ip) {
        ImageProcessor ip2 = ip;
        if (ip2 instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            ip2 = ((ColorProcessor)ip2).getBrightness();
        }
        Rectangle roiRect = ip2.getRoi();
        int maxN = Math.max(roiRect.width, roiRect.height);
        double sharpness = (100.0 - toleranceDia) / 100.0;
        boolean doScaling = doScalingDia;
        boolean saturate = saturateDia;
        IJ.showProgress(1, 20);
        int i = 2;
        while ((double)i < 1.5 * (double)maxN) {
            i *= 2;
        }
        double filterLarge = 2.0 * filterLargeDia / (double)i;
        double filterSmall = 2.0 * filterSmallDia / (double)i;
        Rectangle fitRect = new Rectangle();
        fitRect.x = (int)Math.round((double)(i - roiRect.width) / 2.0);
        fitRect.y = (int)Math.round((double)(i - roiRect.height) / 2.0);
        fitRect.width = roiRect.width;
        fitRect.height = roiRect.height;
        this.showStatus("Pad to " + i + "x" + i);
        ip2 = this.tileMirror(ip2, i, i, fitRect.x, fitRect.y);
        IJ.showProgress(2, 20);
        this.showStatus(i + "x" + i + " forward transform");
        FHT fht = new FHT(ip2);
        fht.setShowProgress(false);
        fht.transform();
        IJ.showProgress(9, 20);
        this.showStatus("Filter in frequency domain");
        this.filterLargeSmall(fht, filterLarge, filterSmall, choiceIndex, sharpness);
        IJ.showProgress(11, 20);
        this.showStatus("Inverse transform");
        fht.inverseTransform();
        IJ.showProgress(19, 20);
        this.showStatus("Crop and convert to original type");
        fht.setRoi(fitRect);
        ip2 = fht.crop();
        if (doScaling) {
            ImagePlus imp2 = new ImagePlus(this.imp.getTitle() + "-filtered", ip2);
            new ContrastEnhancer().stretchHistogram(imp2, saturate ? 1.0 : 0.0);
            ip2 = imp2.getProcessor();
        }
        int bitDepth = this.imp.getBitDepth();
        switch (bitDepth) {
            case 8: {
                ip2 = ip2.convertToByte(doScaling);
                break;
            }
            case 16: {
                ip2 = ip2.convertToShort(doScaling);
                break;
            }
            case 24: {
                ip.snapshot();
                this.showStatus("Setting brightness");
                ((ColorProcessor)ip).setBrightness((FloatProcessor)ip2);
                break;
            }
        }
        if (bitDepth != 24) {
            ip.snapshot();
            ip.copyBits(ip2, roiRect.x, roiRect.y, 0);
        }
        ip.resetMinAndMax();
        IJ.showProgress(20, 20);
    }

    void showStatus(String msg) {
        if (this.stackSize > 1 && processStack) {
            IJ.showStatus("FFT Filter: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(msg);
        }
    }

    public ImageProcessor tileMirror(ImageProcessor ip, int width, int height, int x, int y) {
        int j;
        int i;
        if (x < 0 || x > width - 1 || y < 0 || y > height - 1) {
            IJ.error("Image to be tiled is out of bounds.");
            return null;
        }
        ImageProcessor ipout = ip.createProcessor(width, height);
        ImageProcessor ip2 = ip.crop();
        int w2 = ip2.getWidth();
        int h2 = ip2.getHeight();
        int i1 = (int)Math.ceil((double)x / (double)w2);
        int i2 = (int)Math.ceil((double)(width - x) / (double)w2);
        int j1 = (int)Math.ceil((double)y / (double)h2);
        int j2 = (int)Math.ceil((double)(height - y) / (double)h2);
        if ((double)(i1 % 2) > 0.5) {
            ip2.flipHorizontal();
        }
        if ((double)(j1 % 2) > 0.5) {
            ip2.flipVertical();
        }
        for (i = -i1; i < i2; i += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i = -i1 + 1; i < i2; i += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipVertical();
        for (i = -i1 + 1; i < i2; i += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i = -i1; i < i2; i += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        return ipout;
    }

    void filterLargeSmall(ImageProcessor ip, double filterLarge, double filterSmall, int stripesHorVert, double scaleStripes) {
        float colFactSmall;
        float colFactLarge;
        int backcol;
        int col;
        float rowFactSmall;
        float rowFactLarge;
        int backrow;
        int row;
        int maxN = ip.getWidth();
        float[] fht = (float[])ip.getPixels();
        float[] filter = new float[maxN * maxN];
        for (int i = 0; i < maxN * maxN; ++i) {
            filter[i] = 1.0f;
        }
        double scaleLarge = filterLarge * filterLarge;
        double scaleSmall = filterSmall * filterSmall;
        scaleStripes *= scaleStripes;
        for (int j = 1; j < maxN / 2; ++j) {
            row = j * maxN;
            backrow = (maxN - j) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j * j)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j * j)) * scaleSmall);
            for (col = 1; col < maxN / 2; ++col) {
                backcol = maxN - col;
                colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
                colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
                float factor = (1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall;
                switch (stripesHorVert) {
                    case 1: {
                        factor *= 1.0f - (float)Math.exp((double)(-(col * col)) * scaleStripes);
                        break;
                    }
                    case 2: {
                        factor *= 1.0f - (float)Math.exp((double)(-(j * j)) * scaleStripes);
                    }
                }
                int n = col + row;
                fht[n] = fht[n] * factor;
                int n2 = col + backrow;
                fht[n2] = fht[n2] * factor;
                int n3 = backcol + row;
                fht[n3] = fht[n3] * factor;
                int n4 = backcol + backrow;
                fht[n4] = fht[n4] * factor;
                int n5 = col + row;
                filter[n5] = filter[n5] * factor;
                int n6 = col + backrow;
                filter[n6] = filter[n6] * factor;
                int n7 = backcol + row;
                filter[n7] = filter[n7] * factor;
                int n8 = backcol + backrow;
                filter[n8] = filter[n8] * factor;
            }
        }
        int rowmid = maxN * (maxN / 2);
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        float factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
        int n = maxN / 2;
        fht[n] = fht[n] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n9 = rowmid;
        fht[n9] = fht[n9] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n10 = maxN / 2 + rowmid;
        fht[n10] = fht[n10] * ((1.0f - rowFactLarge * rowFactLarge) * rowFactSmall * rowFactSmall);
        int n11 = maxN / 2;
        filter[n11] = filter[n11] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n12 = rowmid;
        filter[n12] = filter[n12] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n13 = maxN / 2 + rowmid;
        filter[n13] = filter[n13] * ((1.0f - rowFactLarge * rowFactLarge) * rowFactSmall * rowFactSmall);
        switch (stripesHorVert) {
            case 1: {
                int n14 = maxN / 2;
                fht[n14] = fht[n14] * (1.0f - factStripes);
                fht[rowmid] = 0.0f;
                int n15 = maxN / 2 + rowmid;
                fht[n15] = fht[n15] * (1.0f - factStripes);
                int n16 = maxN / 2;
                filter[n16] = filter[n16] * (1.0f - factStripes);
                filter[rowmid] = 0.0f;
                int n17 = maxN / 2 + rowmid;
                filter[n17] = filter[n17] * (1.0f - factStripes);
                break;
            }
            case 2: {
                fht[maxN / 2] = 0.0f;
                int n18 = rowmid;
                fht[n18] = fht[n18] * (1.0f - factStripes);
                int n19 = maxN / 2 + rowmid;
                fht[n19] = fht[n19] * (1.0f - factStripes);
                filter[maxN / 2] = 0.0f;
                int n20 = rowmid;
                filter[n20] = filter[n20] * (1.0f - factStripes);
                int n21 = maxN / 2 + rowmid;
                filter[n21] = filter[n21] * (1.0f - factStripes);
            }
        }
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        block21: for (col = 1; col < maxN / 2; ++col) {
            backcol = maxN - col;
            colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
            colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n22 = col;
                    fht[n22] = fht[n22] * ((1.0f - colFactLarge) * colFactSmall);
                    int n23 = backcol;
                    fht[n23] = fht[n23] * ((1.0f - colFactLarge) * colFactSmall);
                    int n24 = col + rowmid;
                    fht[n24] = fht[n24] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n25 = backcol + rowmid;
                    fht[n25] = fht[n25] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n26 = col;
                    filter[n26] = filter[n26] * ((1.0f - colFactLarge) * colFactSmall);
                    int n27 = backcol;
                    filter[n27] = filter[n27] * ((1.0f - colFactLarge) * colFactSmall);
                    int n28 = col + rowmid;
                    filter[n28] = filter[n28] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n29 = backcol + rowmid;
                    filter[n29] = filter[n29] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    continue block21;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(col * col)) * scaleStripes);
                    int n30 = col;
                    fht[n30] = fht[n30] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n31 = backcol;
                    fht[n31] = fht[n31] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n32 = col + rowmid;
                    fht[n32] = fht[n32] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n33 = backcol + rowmid;
                    fht[n33] = fht[n33] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n34 = col;
                    filter[n34] = filter[n34] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n35 = backcol;
                    filter[n35] = filter[n35] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n36 = col + rowmid;
                    filter[n36] = filter[n36] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n37 = backcol + rowmid;
                    filter[n37] = filter[n37] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    continue block21;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[col] = 0.0f;
                    fht[backcol] = 0.0f;
                    int n38 = col + rowmid;
                    fht[n38] = fht[n38] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n39 = backcol + rowmid;
                    fht[n39] = fht[n39] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    filter[col] = 0.0f;
                    filter[backcol] = 0.0f;
                    int n40 = col + rowmid;
                    filter[n40] = filter[n40] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n41 = backcol + rowmid;
                    filter[n41] = filter[n41] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                }
            }
        }
        colFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        colFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        block22: for (int j = 1; j < maxN / 2; ++j) {
            row = j * maxN;
            backrow = (maxN - j) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j * j)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j * j)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n42 = row;
                    fht[n42] = fht[n42] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n43 = backrow;
                    fht[n43] = fht[n43] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n44 = row + maxN / 2;
                    fht[n44] = fht[n44] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n45 = backrow + maxN / 2;
                    fht[n45] = fht[n45] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n46 = row;
                    filter[n46] = filter[n46] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n47 = backrow;
                    filter[n47] = filter[n47] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n48 = row + maxN / 2;
                    filter[n48] = filter[n48] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n49 = backrow + maxN / 2;
                    filter[n49] = filter[n49] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    continue block22;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[row] = 0.0f;
                    fht[backrow] = 0.0f;
                    int n50 = row + maxN / 2;
                    fht[n50] = fht[n50] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n51 = backrow + maxN / 2;
                    fht[n51] = fht[n51] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    filter[row] = 0.0f;
                    filter[backrow] = 0.0f;
                    int n52 = row + maxN / 2;
                    filter[n52] = filter[n52] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n53 = backrow + maxN / 2;
                    filter[n53] = filter[n53] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    continue block22;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(j * j)) * scaleStripes);
                    int n54 = row;
                    fht[n54] = fht[n54] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n55 = backrow;
                    fht[n55] = fht[n55] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n56 = row + maxN / 2;
                    fht[n56] = fht[n56] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n57 = backrow + maxN / 2;
                    fht[n57] = fht[n57] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n58 = row;
                    filter[n58] = filter[n58] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n59 = backrow;
                    filter[n59] = filter[n59] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n60 = row + maxN / 2;
                    filter[n60] = filter[n60] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n61 = backrow + maxN / 2;
                    filter[n61] = filter[n61] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                }
            }
        }
        if (displayFilter && this.slice == 1) {
            FHT f = new FHT(new FloatProcessor(maxN, maxN, filter, null));
            f.swapQuadrants();
            new ImagePlus("Filter", f).show();
        }
    }

    boolean showBandpassDialog(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("FFT Bandpass Filter");
        gd.addNumericField("Filter_large structures down to", filterLargeDia, 0, 4, "pixels");
        gd.addNumericField("Filter_small structures up to", filterSmallDia, 0, 4, "pixels");
        gd.addChoice("Suppress stripes:", choices, choiceDia);
        gd.addNumericField("Tolerance of direction:", toleranceDia, 0, 2, "%");
        gd.addCheckbox("Autoscale after filtering", doScalingDia);
        gd.addCheckbox("Saturate image when autoscaling", saturateDia);
        gd.addCheckbox("Display filter", displayFilter);
        if (this.stackSize > 1) {
            gd.addCheckbox("Process entire stack", processStack);
        }
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-bandpass");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (gd.invalidNumber()) {
            IJ.error("Error", "Invalid input number");
            return false;
        }
        filterLargeDia = gd.getNextNumber();
        filterSmallDia = gd.getNextNumber();
        choiceIndex = gd.getNextChoiceIndex();
        choiceDia = choices[choiceIndex];
        toleranceDia = gd.getNextNumber();
        doScalingDia = gd.getNextBoolean();
        saturateDia = gd.getNextBoolean();
        displayFilter = gd.getNextBoolean();
        if (this.stackSize > 1) {
            processStack = gd.getNextBoolean();
        }
        return true;
    }
}

