/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.TagUtils;

abstract class AbstractDicomElement
implements DicomElement {
    protected static final int TO_STRING_MAX_VAL_LEN = 64;
    protected transient int tag;
    protected transient VR vr;
    protected transient boolean bigEndian;

    public AbstractDicomElement(int tag, VR vr, boolean bigEndian) {
        this.tag = tag;
        this.vr = vr;
        this.bigEndian = bigEndian;
    }

    public int hashCode() {
        return this.tag;
    }

    @Override
    public final boolean bigEndian() {
        return this.bigEndian;
    }

    @Override
    public final int tag() {
        return this.tag;
    }

    @Override
    public final VR vr() {
        return this.vr;
    }

    public String toString() {
        return this.toStringBuffer(null, 64).toString();
    }

    @Override
    public StringBuffer toStringBuffer(StringBuffer sb, int maxValLen) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        TagUtils.toStringBuffer(this.tag, sb);
        sb.append(' ');
        sb.append(this.vr);
        sb.append(" #");
        sb.append(this.length());
        sb.append(" [");
        this.appendValue(sb, maxValLen);
        sb.append("]");
        return sb;
    }

    protected abstract void appendValue(StringBuffer var1, int var2);

    @Override
    public DicomElement bigEndian(boolean bigEndian) {
        if (this.bigEndian == bigEndian) {
            return this;
        }
        this.toggleEndian();
        this.bigEndian = bigEndian;
        return this;
    }

    protected abstract void toggleEndian();
}

