/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObjectToStringParam;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;

public interface DicomObject
extends Serializable {
    public int size();

    public boolean isEmpty();

    public void clear();

    public DicomObject getRoot();

    public boolean isRoot();

    public DicomObject getParent();

    public void setParent(DicomObject var1);

    public SpecificCharacterSet getSpecificCharacterSet();

    public Iterator<DicomElement> iterator();

    public Iterator<DicomElement> iterator(int var1, int var2);

    public Iterator<DicomElement> commandIterator();

    public Iterator<DicomElement> fileMetaInfoIterator();

    public Iterator<DicomElement> datasetIterator();

    public int getItemPosition();

    public void setItemPosition(int var1);

    public long getItemOffset();

    public void setItemOffset(long var1);

    public VR vrOf(int var1);

    public String nameOf(int var1);

    public int resolveTag(int var1, String var2);

    public int resolveTag(int var1, String var2, boolean var3);

    public String getPrivateCreator(int var1);

    public int vm(int var1);

    public boolean contains(int var1);

    public boolean containsValue(int var1);

    public boolean containsAll(DicomObject var1);

    public boolean accept(Visitor var1);

    public void add(DicomElement var1);

    public DicomElement remove(int var1);

    public DicomElement remove(int[] var1);

    public DicomElement get(int var1);

    public DicomElement get(int var1, VR var2);

    public DicomElement get(int[] var1);

    public DicomElement get(int[] var1, VR var2);

    public byte[] getBytes(int var1, boolean var2);

    public byte[] getBytes(int var1);

    public byte[] getBytes(int[] var1, boolean var2);

    public byte[] getBytes(int[] var1);

    public DicomObject getNestedDicomObject(int var1);

    public DicomObject getNestedDicomObject(int[] var1);

    public int getInt(int var1);

    public int getInt(int var1, VR var2);

    public int getInt(int var1, int var2);

    public int getInt(int var1, VR var2, int var3);

    public int getInt(int[] var1);

    public int getInt(int[] var1, VR var2);

    public int getInt(int[] var1, int var2);

    public int getInt(int[] var1, VR var2, int var3);

    public int[] getInts(int var1);

    public int[] getInts(int var1, VR var2);

    public int[] getInts(int var1, int[] var2);

    public int[] getInts(int var1, VR var2, int[] var3);

    public int[] getInts(int[] var1);

    public int[] getInts(int[] var1, VR var2);

    public int[] getInts(int[] var1, int[] var2);

    public int[] getInts(int[] var1, VR var2, int[] var3);

    public short[] getShorts(int var1);

    public short[] getShorts(int var1, VR var2);

    public short[] getShorts(int var1, short[] var2);

    public short[] getShorts(int var1, VR var2, short[] var3);

    public short[] getShorts(int[] var1);

    public short[] getShorts(int[] var1, VR var2);

    public short[] getShorts(int[] var1, short[] var2);

    public short[] getShorts(int[] var1, VR var2, short[] var3);

    public float getFloat(int var1);

    public float getFloat(int var1, VR var2);

    public float getFloat(int var1, float var2);

    public float getFloat(int var1, VR var2, float var3);

    public float getFloat(int[] var1);

    public float getFloat(int[] var1, VR var2);

    public float getFloat(int[] var1, float var2);

    public float getFloat(int[] var1, VR var2, float var3);

    public float[] getFloats(int var1);

    public float[] getFloats(int var1, VR var2);

    public float[] getFloats(int var1, float[] var2);

    public float[] getFloats(int var1, VR var2, float[] var3);

    public float[] getFloats(int[] var1);

    public float[] getFloats(int[] var1, VR var2);

    public float[] getFloats(int[] var1, float[] var2);

    public float[] getFloats(int[] var1, VR var2, float[] var3);

    public double getDouble(int var1);

    public double getDouble(int var1, VR var2);

    public double getDouble(int var1, double var2);

    public double getDouble(int var1, VR var2, double var3);

    public double getDouble(int[] var1);

    public double getDouble(int[] var1, VR var2);

    public double getDouble(int[] var1, double var2);

    public double getDouble(int[] var1, VR var2, double var3);

    public double[] getDoubles(int var1);

    public double[] getDoubles(int var1, VR var2);

    public double[] getDoubles(int var1, double[] var2);

    public double[] getDoubles(int var1, VR var2, double[] var3);

    public double[] getDoubles(int[] var1);

    public double[] getDoubles(int[] var1, VR var2);

    public double[] getDoubles(int[] var1, double[] var2);

    public double[] getDoubles(int[] var1, VR var2, double[] var3);

    public String getString(int var1);

    public String getString(int var1, VR var2);

    public String getString(int var1, String var2);

    public String getString(int var1, VR var2, String var3);

    public String getString(int[] var1);

    public String getString(int[] var1, VR var2);

    public String getString(int[] var1, String var2);

    public String getString(int[] var1, VR var2, String var3);

    public String[] getStrings(int var1);

    public String[] getStrings(int var1, VR var2);

    public String[] getStrings(int var1, String[] var2);

    public String[] getStrings(int var1, VR var2, String[] var3);

    public String[] getStrings(int[] var1);

    public String[] getStrings(int[] var1, VR var2);

    public String[] getStrings(int[] var1, String[] var2);

    public String[] getStrings(int[] var1, VR var2, String[] var3);

    public Date getDate(int var1);

    public Date getDate(int var1, VR var2);

    public Date getDate(int var1, Date var2);

    public Date getDate(int var1, VR var2, Date var3);

    public Date getDate(int var1, int var2);

    public Date getDate(int var1, int var2, Date var3);

    public Date getDate(int[] var1);

    public Date getDate(int[] var1, VR var2);

    public Date getDate(int[] var1, Date var2);

    public Date getDate(int[] var1, VR var2, Date var3);

    public Date getDate(int[] var1, int var2, int var3);

    public Date getDate(int[] var1, int var2, int var3, Date var4);

    public Date[] getDates(int var1);

    public Date[] getDates(int var1, VR var2);

    public Date[] getDates(int var1, Date[] var2);

    public Date[] getDates(int var1, VR var2, Date[] var3);

    public Date[] getDates(int var1, int var2);

    public Date[] getDates(int var1, int var2, Date[] var3);

    public Date[] getDates(int[] var1);

    public Date[] getDates(int[] var1, VR var2);

    public Date[] getDates(int[] var1, Date[] var2);

    public Date[] getDates(int[] var1, VR var2, Date[] var3);

    public Date[] getDates(int[] var1, int var2, int var3);

    public Date[] getDates(int[] var1, int var2, int var3, Date[] var4);

    public DateRange getDateRange(int var1);

    public DateRange getDateRange(int var1, VR var2);

    public DateRange getDateRange(int var1, DateRange var2);

    public DateRange getDateRange(int var1, VR var2, DateRange var3);

    public DateRange getDateRange(int var1, int var2);

    public DateRange getDateRange(int var1, int var2, DateRange var3);

    public DateRange getDateRange(int[] var1);

    public DateRange getDateRange(int[] var1, VR var2);

    public DateRange getDateRange(int[] var1, DateRange var2);

    public DateRange getDateRange(int[] var1, VR var2, DateRange var3);

    public DateRange getDateRange(int[] var1, int var2, int var3);

    public DateRange getDateRange(int[] var1, int var2, int var3, DateRange var4);

    public DicomElement putNull(int var1, VR var2);

    public DicomElement putBytes(int var1, VR var2, byte[] var3);

    public DicomElement putBytes(int var1, VR var2, byte[] var3, boolean var4);

    public DicomElement putNestedDicomObject(int var1, DicomObject var2);

    public DicomElement putInt(int var1, VR var2, int var3);

    public DicomElement putInts(int var1, VR var2, int[] var3);

    public DicomElement putShorts(int var1, VR var2, short[] var3);

    public DicomElement putFloat(int var1, VR var2, float var3);

    public DicomElement putFloats(int var1, VR var2, float[] var3);

    public DicomElement putDouble(int var1, VR var2, double var3);

    public DicomElement putDoubles(int var1, VR var2, double[] var3);

    public DicomElement putString(int var1, VR var2, String var3);

    public DicomElement putStrings(int var1, VR var2, String[] var3);

    public DicomElement putDate(int var1, VR var2, Date var3);

    public DicomElement putDates(int var1, VR var2, Date[] var3);

    public DicomElement putDateRange(int var1, VR var2, DateRange var3);

    public DicomElement putSequence(int var1);

    public DicomElement putSequence(int var1, int var2);

    public DicomElement putFragments(int var1, VR var2, boolean var3);

    public DicomElement putFragments(int var1, VR var2, boolean var3, int var4);

    public DicomElement putNull(int[] var1, VR var2);

    public DicomElement putBytes(int[] var1, VR var2, byte[] var3);

    public DicomElement putBytes(int[] var1, VR var2, byte[] var3, boolean var4);

    public DicomElement putNestedDicomObject(int[] var1, DicomObject var2);

    public DicomElement putInt(int[] var1, VR var2, int var3);

    public DicomElement putInts(int[] var1, VR var2, int[] var3);

    public DicomElement putShorts(int[] var1, VR var2, short[] var3);

    public DicomElement putFloat(int[] var1, VR var2, float var3);

    public DicomElement putFloats(int[] var1, VR var2, float[] var3);

    public DicomElement putDouble(int[] var1, VR var2, double var3);

    public DicomElement putDoubles(int[] var1, VR var2, double[] var3);

    public DicomElement putString(int[] var1, VR var2, String var3);

    public DicomElement putStrings(int[] var1, VR var2, String[] var3);

    public DicomElement putDate(int[] var1, VR var2, Date var3);

    public DicomElement putDates(int[] var1, VR var2, Date[] var3);

    public DicomElement putDateRange(int[] var1, VR var2, DateRange var3);

    public DicomElement putSequence(int[] var1);

    public DicomElement putSequence(int[] var1, int var2);

    public DicomElement putFragments(int[] var1, VR var2, boolean var3);

    public DicomElement putFragments(int[] var1, VR var2, boolean var3, int var4);

    public void shareElements();

    public void serializeElements(ObjectOutputStream var1) throws IOException;

    public void copyTo(DicomObject var1);

    public boolean matches(DicomObject var1, boolean var2);

    public boolean cacheGet();

    public void cacheGet(boolean var1);

    public boolean cachePut();

    public void cachePut(boolean var1);

    public boolean bigEndian();

    public void bigEndian(boolean var1);

    public DicomObject command();

    public DicomObject dataset();

    public DicomObject fileMetaInfo();

    public DicomObject subSet(DicomObject var1);

    public DicomObject subSet(int var1, int var2);

    public DicomObject subSet(int[] var1);

    public DicomObject exclude(int[] var1);

    public DicomObject excludePrivate();

    public void initFileMetaInformation(String var1);

    public void initFileMetaInformation(String var1, String var2, String var3);

    public int toStringBuffer(StringBuffer var1, DicomObjectToStringParam var2);

    public static interface Visitor {
        public boolean visit(DicomElement var1);
    }
}

