/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Date;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.dcm4che2.data.AbstractDicomElement;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;

class SimpleDicomElement
extends AbstractDicomElement {
    private static final long serialVersionUID = 4049072757025092152L;
    static final WeakHashMap<SimpleDicomElement, WeakReference<SimpleDicomElement>> shared = new WeakHashMap();
    private static final ThreadLocal<char[]> cbuf = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[64];
        }
    };
    private static final byte[] NULL_VALUE = new byte[0];
    private transient byte[] value;
    private volatile transient Object cachedValue;

    public SimpleDicomElement(int tag, VR vr, boolean bigEndian, byte[] value, Object cachedValue) {
        super(tag, vr, bigEndian);
        this.value = value == null ? NULL_VALUE : value;
        this.cachedValue = cachedValue;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.tag);
        s.writeShort(this.vr.code());
        s.writeBoolean(this.bigEndian);
        s.writeInt(this.value.length);
        if (this.value.length != 0) {
            s.write(this.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.tag = s.readInt();
        this.vr = VR.valueOf(s.readUnsignedShort());
        this.bigEndian = s.readBoolean();
        int len = s.readInt();
        if (len != 0) {
            this.value = new byte[len];
            s.readFully(this.value);
        } else {
            this.value = NULL_VALUE;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleDicomElement)) {
            return false;
        }
        SimpleDicomElement other = (SimpleDicomElement)o;
        return this.tag == other.tag && this.vr == other.vr && Arrays.equals(this.value, other.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DicomElement share() {
        WeakHashMap<SimpleDicomElement, WeakReference<SimpleDicomElement>> weakHashMap = shared;
        synchronized (weakHashMap) {
            DicomElement e;
            WeakReference<SimpleDicomElement> wr = shared.get(this);
            if (wr != null && (e = (DicomElement)wr.get()) != null) {
                return e;
            }
            shared.put(this, new WeakReference<SimpleDicomElement>(this));
        }
        return this;
    }

    @Override
    protected void appendValue(StringBuffer sb, int maxValLen) {
        this.vr.promptValue(this.value, this.bigEndian, null, cbuf.get(), maxValLen, sb);
    }

    @Override
    protected void toggleEndian() {
        this.vr.toggleEndian(this.value);
    }

    @Override
    public final int length() {
        return this.value.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public final boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public int vm(SpecificCharacterSet cs) {
        return this.vr.vm(this.value, cs);
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public short[] getShorts(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof short[]) {
            return (short[])tmp;
        }
        short[] val = this.vr.toShorts(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public int getInt(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Integer) {
            return (Integer)tmp;
        }
        int val = this.vr.toInt(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public int[] getInts(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof int[]) {
            return (int[])tmp;
        }
        int[] val = this.vr.toInts(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public float getFloat(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Float) {
            return ((Float)tmp).floatValue();
        }
        float val = this.vr.toFloat(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = new Float(val);
        }
        return val;
    }

    @Override
    public float[] getFloats(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof float[]) {
            return (float[])tmp;
        }
        float[] val = this.vr.toFloats(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public double getDouble(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Double) {
            return (Double)tmp;
        }
        double val = this.vr.toDouble(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = new Double(val);
        }
        return val;
    }

    @Override
    public double[] getDoubles(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof double[]) {
            return (double[])tmp;
        }
        double[] val = this.vr.toDoubles(this.value, this.bigEndian);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public String getString(SpecificCharacterSet cs, boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof String) {
            return (String)tmp;
        }
        String val = this.vr.toString(this.value, this.bigEndian, cs);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public String[] getStrings(SpecificCharacterSet cs, boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof String[]) {
            return (String[])tmp;
        }
        String[] val = this.vr.toStrings(this.value, this.bigEndian, cs);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public Date getDate(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Date) {
            return (Date)tmp;
        }
        Date val = this.vr.toDate(this.value);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public Date[] getDates(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Date[]) {
            return (Date[])tmp;
        }
        Date[] val = this.vr.toDates(this.value);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public DateRange getDateRange(boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof DateRange) {
            return (DateRange)tmp;
        }
        DateRange val = this.vr.toDateRange(this.value);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public Pattern getPattern(SpecificCharacterSet cs, boolean ignoreCase, boolean cache) {
        Object tmp;
        if (cache && (tmp = this.cachedValue) instanceof Pattern && ((Pattern)tmp).flags() == (ignoreCase ? 66 : 0)) {
            return (Pattern)tmp;
        }
        Pattern val = this.vr.toPattern(this.value, this.bigEndian, cs, ignoreCase);
        if (cache) {
            this.cachedValue = val;
        }
        return val;
    }

    @Override
    public final boolean hasItems() {
        return false;
    }

    @Override
    public final boolean hasDicomObjects() {
        return false;
    }

    @Override
    public final boolean hasFragments() {
        return false;
    }

    @Override
    public final int countItems() {
        return -1;
    }

    @Override
    public DicomObject getDicomObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject getDicomObject(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject removeDicomObject(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeDicomObject(DicomObject item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject addDicomObject(DicomObject item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject addDicomObject(int index, DicomObject item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomObject setDicomObject(int index, DicomObject item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getFragment(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] removeFragment(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFragment(byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] addFragment(byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] addFragment(int index, byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] setFragment(int index, byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DicomElement filterItems(DicomObject filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValueAsString(SpecificCharacterSet cs, int truncate) {
        if (this.value == null || this.value.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(64);
        this.vr.promptValue(this.value, this.bigEndian, cs, cbuf.get(), truncate, sb);
        return sb.toString();
    }
}

