/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.xnat.fileManager;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import org.apache.commons.lang.StringEscapeUtils;
import org.nrg.net.JSESSIONIDCookie;
import org.nrg.xdat.bean.CatCatalogBean;
import org.nrg.xdat.bean.CatEntryBean;
import org.nrg.xdat.bean.CatEntryMetafieldBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;

public class DownloaderApplet
extends Applet {
    Label m_Status = new Label("Initializing session...");
    Label m_ProgressCaption = new Label("Overall progress:");
    Label m_LocFolderLabel = new Label("Select local folder:");
    TextField m_LocFolderEdit = new TextField();
    Button m_BrowseButton = new Button("Browse...");
    JProgressBar m_Progress = new JProgressBar(0, 0, 100);
    Button m_MainButton = new Button("Start");
    protected final int DOWNLOAD_STOPPED = 0;
    protected final int DOWNLOAD_FINISHED = 1;
    protected final int DOWNLOAD_PROGRESS = 2;
    protected final int SESSION_EMPTY = 0;
    protected final int SESSION_PROGRESS = 1;
    protected final int SESSION_FINISHED = 2;
    protected int m_DownloadStatus = 0;
    protected int m_SessionStatus = 0;
    InitSessionThread m_ist = new InitSessionThread();
    Downloader m_downloader = new Downloader();
    Vector m_Files = new Vector();
    File m_SaveDirectory = null;
    private long m_TotalSize = 0L;
    private long m_TotalCount = 0L;
    private long m_nFiles = 1L;
    private long m_Compr = 0L;
    private long m_Uncompr = 0L;
    private double m_ComprRatio = 3.0;
    private Object[] m_CurrentFile = null;
    private JSESSIONIDCookie jsessionidCookie;
    public static int GZ_THREADS = 0;

    @Override
    public void init() {
        this.m_DownloadStatus = 0;
        System.out.println("init: file-downloader : 1.6");
        this.setBackground(Color.white);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        Font lightFont = new Font("Verdana", 0, 11);
        Font boldFont = new Font("Verdana", 1, 11);
        int iVert = 5;
        int iLeft = 5;
        int iRight = 5;
        int iGap = 5;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(iVert, iLeft, iGap, iRight);
        this.m_Status.setFont(boldFont);
        this.m_Status.setAlignment(0);
        this.AddPanelComponent(this.m_Status, layout, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(0, iLeft, iGap, 0);
        this.m_LocFolderLabel.setFont(lightFont);
        this.m_LocFolderLabel.setAlignment(0);
        this.AddPanelComponent(this.m_LocFolderLabel, layout, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 5.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, iGap, 5);
        this.m_LocFolderEdit.setFont(lightFont);
        this.AddPanelComponent(this.m_LocFolderEdit, layout, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, iGap + 2, iRight);
        this.m_BrowseButton.setFont(boldFont);
        this.AddPanelComponent(this.m_BrowseButton, layout, gbc);
        this.m_BrowseButton.addActionListener(new DownloadButtonListener());
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(0, iLeft, iVert, 0);
        this.m_ProgressCaption.setFont(lightFont);
        this.m_ProgressCaption.setAlignment(0);
        this.AddPanelComponent(this.m_ProgressCaption, layout, gbc);
        gbc.insets = new Insets(0, 0, iVert, 5);
        gbc.gridwidth = -1;
        gbc.weightx = 5.0;
        gbc.fill = 2;
        this.m_Progress.setBackground(Color.white);
        this.AddPanelComponent(this.m_Progress, layout, gbc);
        gbc.insets = new Insets(0, 0, iVert, iRight);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        this.m_MainButton.setFont(boldFont);
        this.AddPanelComponent(this.m_MainButton, layout, gbc);
        this.m_MainButton.addActionListener(new DownloadButtonListener());
        this.jsessionidCookie = new JSESSIONIDCookie(this.getParameter("jsessionid"));
        this.m_downloader.start();
        this.m_ist.start();
    }

    protected void AddPanelComponent(Component comp, GridBagLayout layout, GridBagConstraints con) {
        layout.setConstraints(comp, con);
        this.add(comp);
    }

    protected synchronized void UpdateStatus(String s) {
        this.m_Status.setText(s);
        if (this.m_SessionStatus == 0) {
            this.m_MainButton.setEnabled(false);
            this.AllowFolderSelection(false);
            return;
        }
        switch (this.m_DownloadStatus) {
            case 0: {
                this.m_MainButton.setLabel("Start");
                this.m_MainButton.setEnabled(true);
                break;
            }
            case 1: {
                this.m_MainButton.setEnabled(false);
                this.m_BrowseButton.setEnabled(false);
                break;
            }
            case 2: {
                this.m_MainButton.setLabel("Stop");
                this.m_MainButton.setEnabled(true);
            }
        }
    }

    synchronized void AllowFolderSelection(boolean bAllow) {
        this.m_BrowseButton.setEnabled(bAllow);
        this.m_LocFolderEdit.setEnabled(bAllow);
    }

    synchronized void AddFileToQueue(Object[] file) {
        ++this.m_TotalCount;
        this.m_Files.add(file);
        if (this.m_TotalSize != -1L) {
            this.m_TotalSize = (Long)file[2] == -1L ? -1L : (this.m_TotalSize += ((Long)file[2]).longValue());
        }
    }

    synchronized Object[] RemoveFileFromQueue() {
        if (this.m_Files.size() < 1) {
            return null;
        }
        Object[] file = (Object[])this.m_Files.get(0);
        this.m_Files.remove(0);
        return file;
    }

    synchronized boolean IsFileQueueEmpty() {
        return this.m_Files.size() < 1;
    }

    private static URL buildUrl(String url) {
        try {
            String[] labelTypes;
            url = URLDecoder.decode(url, "UTF-8");
            url = StringEscapeUtils.unescapeXml((String)url);
            for (String labelType : labelTypes = new String[]{"scans", "resources", "reconstructions", "assessors"}) {
                url = DownloaderApplet.urlEncodeItemLabel(url, labelType);
            }
            return new URL(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String urlEncodeItemLabel(String url, String labelType) throws Exception {
        String labelRegex = "(?<=\\/" + labelType + "\\/)(.+?)(?=\\/)";
        Matcher matcher = Pattern.compile(labelRegex).matcher(url);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.replaceFirst(URLEncoder.encode(matcher.group(1), "UTF-8"));
        }
        return url;
    }

    static /* synthetic */ Object[] access$002(DownloaderApplet x0, Object[] x1) {
        x0.m_CurrentFile = x1;
        return x1;
    }

    class DownloadButtonListener
    implements ActionListener {
        DownloadButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DownloaderApplet.this.m_BrowseButton) {
                if (DownloaderApplet.this.m_downloader.SelectLocalFolder()) {
                    DownloaderApplet.this.m_LocFolderEdit.setText(DownloaderApplet.this.m_SaveDirectory.getPath());
                }
            } else if (DownloaderApplet.this.m_DownloadStatus == 0) {
                if (DownloaderApplet.this.m_SaveDirectory != null) {
                    DownloaderApplet.this.m_DownloadStatus = 2;
                    DownloaderApplet.this.m_MainButton.setLabel("Stop");
                    DownloaderApplet.this.AllowFolderSelection(false);
                } else if (DownloaderApplet.this.m_downloader.SelectLocalFolder(DownloaderApplet.this.m_LocFolderEdit.getText())) {
                    DownloaderApplet.this.m_DownloadStatus = 2;
                    DownloaderApplet.this.m_MainButton.setLabel("Stop");
                    DownloaderApplet.this.AllowFolderSelection(false);
                } else {
                    DownloaderApplet.this.UpdateStatus("Select local folder to start.");
                }
            } else if (DownloaderApplet.this.m_DownloadStatus == 2) {
                DownloaderApplet.this.m_DownloadStatus = 0;
                DownloaderApplet.this.m_MainButton.setLabel("Resume");
            }
        }
    }

    class Downloader
    extends Thread {
        final JFileChooser m_fc = new JFileChooser();
        private long m_TotalBytesLoaded = 0L;
        private int m_CurPercent = 0;
        private GZUnzipperPool pool = new GZUnzipperPool();
        public static final int ZIP_DOWNLOAD = 10240;

        Downloader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int sleep_time = 500;
            try {
                block6: do {
                    if (DownloaderApplet.this.m_SessionStatus == 0) {
                        DownloaderApplet.this.UpdateStatus("Initializing session...");
                        Thread.sleep(sleep_time);
                        continue;
                    }
                    switch (DownloaderApplet.this.m_DownloadStatus) {
                        case 2: {
                            if (DownloaderApplet.this.m_SaveDirectory == null) {
                                DownloaderApplet.this.m_DownloadStatus = 0;
                                DownloaderApplet.this.UpdateStatus("Select local folder to save files.");
                                sleep_time = 500;
                                continue block6;
                            }
                            while (!DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this.m_DownloadStatus != 0) {
                                this.DownloadNextFile();
                            }
                            if (DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this.m_SessionStatus == 2 && GZ_THREADS == 0) {
                                DownloaderApplet.this.m_DownloadStatus = 1;
                                DownloaderApplet.this.UpdateStatus("Download complete.");
                                DownloaderApplet.this.m_Progress.setValue(100);
                            } else if (DownloaderApplet.this.IsFileQueueEmpty() && DownloaderApplet.this.m_SessionStatus == 2) {
                                DownloaderApplet.this.UpdateStatus("Finishing GZ extraction...");
                                DownloaderApplet.this.m_Progress.setValue(99);
                            }
                            sleep_time = 100;
                            break;
                        }
                        case 0: {
                            sleep_time = 500;
                        }
                    }
                    Thread.sleep(sleep_time);
                } while (DownloaderApplet.this.m_DownloadStatus != 1);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean SelectLocalFolder() {
            this.m_fc.setFileSelectionMode(1);
            int res = this.m_fc.showSaveDialog(DownloaderApplet.this);
            if (res == 0) {
                DownloaderApplet.this.m_SaveDirectory = this.m_fc.getSelectedFile();
                return true;
            }
            return false;
        }

        public boolean SelectLocalFolder(String path) {
            File f;
            if (path.length() < 1) {
                return false;
            }
            DownloaderApplet.this.m_SaveDirectory = f = new File(path);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int DownloadNextFile() {
            if (DownloaderApplet.this.m_SaveDirectory == null) {
                return -1;
            }
            if (DownloaderApplet.this.m_CurrentFile == null) {
                DownloaderApplet.access$002(DownloaderApplet.this, DownloaderApplet.this.RemoveFileFromQueue());
            }
            if (DownloaderApplet.this.m_CurrentFile == null) {
                return 0;
            }
            Object[] row = DownloaderApplet.this.m_CurrentFile;
            long localSize = 0L;
            String relative = (String)row[0];
            if (relative.equals("ZIP")) {
                try {
                    URL url = DownloaderApplet.buildUrl((String)row[1]);
                    URLConnection connection = url.openConnection();
                    DownloaderApplet.this.jsessionidCookie.setInRequestHeader(connection);
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(connection.getInputStream()));
                    try {
                        ZipEntry entry;
                        byte[] data = new byte[10240];
                        while ((entry = zis.getNextEntry()) != null) {
                            if (!entry.isDirectory()) {
                                FilterOutputStream dest = null;
                                String name = entry.getName();
                                localSize += entry.getSize();
                                File f = new File(DownloaderApplet.this.m_SaveDirectory, name);
                                boolean success = false;
                                try {
                                    int count;
                                    f.getParentFile().mkdirs();
                                    FileOutputStream fos = new FileOutputStream(f);
                                    dest = new BufferedOutputStream(fos, 10240);
                                    while ((count = zis.read(data, 0, 10240)) != -1) {
                                        int percent;
                                        ((BufferedOutputStream)dest).write(data, 0, count);
                                        ((BufferedOutputStream)dest).flush();
                                        this.m_TotalBytesLoaded += (long)count;
                                        if (DownloaderApplet.this.m_SessionStatus != 2) {
                                            DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                                            continue;
                                        }
                                        if (DownloaderApplet.this.m_TotalSize == -1L) {
                                            percent = (int)(DownloaderApplet.this.m_nFiles * 100L / DownloaderApplet.this.m_TotalCount);
                                            if (this.m_TotalBytesLoaded > 0x6400000L) {
                                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 0x100000L + " MB completed");
                                            } else {
                                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                                            }
                                            DownloaderApplet.this.m_Progress.setValue(percent);
                                            continue;
                                        }
                                        percent = (int)(this.m_TotalBytesLoaded * 100L / DownloaderApplet.this.m_TotalSize);
                                        if (this.m_CurPercent >= percent) continue;
                                        this.m_CurPercent = percent;
                                        if (DownloaderApplet.this.m_TotalSize > 0x6400000L) {
                                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 0x100000L + " MB out of " + DownloaderApplet.this.m_TotalSize / 0x100000L + " MB)");
                                        } else {
                                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 1024L + " KB out of " + DownloaderApplet.this.m_TotalSize / 1024L + " KB)");
                                        }
                                        DownloaderApplet.this.m_Progress.setValue(percent);
                                    }
                                    ((BufferedOutputStream)dest).flush();
                                    success = true;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    try {
                                        if (dest != null) {
                                            dest.close();
                                        }
                                    }
                                    catch (Exception e) {}
                                }
                                if (!success || !f.getName().endsWith(".gz")) continue;
                                this.pool.addFile(f);
                                continue;
                            }
                            File df = new File(DownloaderApplet.this.m_SaveDirectory, entry.getName());
                            if (df.exists()) continue;
                            df.mkdirs();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        zis.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    URL url = DownloaderApplet.buildUrl((String)row[1]);
                    URLConnection connection = url.openConnection();
                    DownloaderApplet.this.jsessionidCookie.setInRequestHeader(connection);
                    InputStream bis = null;
                    BufferedOutputStream bos = null;
                    boolean bUnzip = false;
                    if (relative.endsWith(".gz")) {
                        relative = relative.substring(0, relative.length() - 3);
                        bUnzip = true;
                    }
                    localSize = (Long)row[2];
                    File outFile = new File(DownloaderApplet.this.m_SaveDirectory, relative);
                    outFile.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(outFile);
                    bis = connection.getInputStream();
                    if (bUnzip) {
                        bis = new GZIPInputStream(bis);
                    }
                    bos = new BufferedOutputStream(out);
                    byte[] buff = new byte[10240];
                    int bytesRead = 0;
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length)) && DownloaderApplet.this.m_DownloadStatus == 2) {
                        int percent;
                        bos.write(buff, 0, bytesRead);
                        bos.flush();
                        if (bUnzip) {
                            DownloaderApplet.this.m_Uncompr = DownloaderApplet.this.m_Uncompr + (long)bytesRead;
                            this.m_TotalBytesLoaded += (long)((double)bytesRead / DownloaderApplet.this.m_ComprRatio);
                        } else {
                            this.m_TotalBytesLoaded += (long)bytesRead;
                        }
                        if (DownloaderApplet.this.m_SessionStatus != 2) {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed, calculating total size...");
                            continue;
                        }
                        if (DownloaderApplet.this.m_TotalSize == -1L) {
                            percent = (int)(DownloaderApplet.this.m_nFiles * 100L / DownloaderApplet.this.m_TotalCount);
                            if (this.m_TotalBytesLoaded > 0x6400000L) {
                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 0x100000L + " MB completed");
                            } else {
                                DownloaderApplet.this.UpdateStatus("Downloading, " + this.m_TotalBytesLoaded / 1024L + " KB completed");
                            }
                            DownloaderApplet.this.m_Progress.setValue(percent);
                            continue;
                        }
                        percent = (int)(this.m_TotalBytesLoaded * 100L / DownloaderApplet.this.m_TotalSize);
                        if (this.m_CurPercent >= percent) continue;
                        this.m_CurPercent = percent;
                        if (DownloaderApplet.this.m_TotalSize > 0x6400000L) {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 0x100000L + " MB out of " + DownloaderApplet.this.m_TotalSize / 0x100000L + " MB)");
                        } else {
                            DownloaderApplet.this.UpdateStatus("Downloading, " + percent + "% completed (" + this.m_TotalBytesLoaded / 1024L + " KB out of " + DownloaderApplet.this.m_TotalSize / 1024L + " KB)");
                        }
                        DownloaderApplet.this.m_Progress.setValue(percent);
                    }
                    bis.close();
                    bos.flush();
                    bos.close();
                    ((OutputStream)out).close();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (DownloaderApplet.this.m_DownloadStatus == 2) {
                DownloaderApplet.access$002(DownloaderApplet.this, null);
                DownloaderApplet.this.m_nFiles++;
                DownloaderApplet.this.m_Compr = DownloaderApplet.this.m_Compr + localSize;
                if (DownloaderApplet.this.m_Compr > 0L && DownloaderApplet.this.m_Uncompr > 0L) {
                    DownloaderApplet.this.m_ComprRatio = (double)DownloaderApplet.this.m_Uncompr / (double)DownloaderApplet.this.m_Compr;
                }
                return 1;
            }
            return 0;
        }
    }

    public class GZUnzipper
    extends Thread {
        final File f;
        final GZUnzipperPool pool;

        public GZUnzipper(File _f, GZUnzipperPool _pool) {
            this.f = _f;
            this.pool = _pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream is = null;
                OutputStream os = null;
                File outFile = null;
                boolean success = false;
                try {
                    System.out.println(this.f.getAbsolutePath());
                    is = new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.f)));
                    outFile = new File(this.f.getParent(), this.f.getName().substring(0, this.f.getName().length() - 3));
                    if (!outFile.exists()) {
                        int len;
                        os = new BufferedOutputStream(new FileOutputStream(outFile));
                        byte[] buf = new byte[1024];
                        while ((len = is.read(buf)) > 0) {
                            os.write(buf, 0, len);
                        }
                        os.flush();
                        success = true;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    success = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    success = false;
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
                if (success) {
                    this.f.delete();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.pool.endThread();
            }
        }
    }

    public class GZUnzipperPool {
        final int POOL_SIZE = 5;
        LinkedList ll = new LinkedList();

        public void addFile(File f) {
            if (GZ_THREADS <= 5) {
                this.startJob(f);
            } else {
                this.ll.add(f);
            }
        }

        public void startJob(File f) {
            ++GZ_THREADS;
            GZUnzipper u = new GZUnzipper(f, this);
            u.start();
        }

        public void startThread() {
            if (this.ll.size() > 0) {
                File f = (File)this.ll.removeFirst();
                this.startJob(f);
            }
        }

        public synchronized void endThread() {
            if (GZ_THREADS > 0) {
                --GZ_THREADS;
            }
            this.startThread();
        }
    }

    class InitSessionThread
    extends Thread {
        int nSessions = 0;

        InitSessionThread() {
        }

        @Override
        public void run() {
            DownloaderApplet.this.UpdateStatus("Initializing session...");
            DownloaderApplet.this.m_SessionStatus = 0;
            this.InitSession();
            DownloaderApplet.this.m_SessionStatus = 2;
        }

        private boolean TestFunction() {
            boolean bTest = false;
            if (!bTest) {
                return false;
            }
            ArrayList<String> sessions = new ArrayList<String>();
            ArrayList<String> projects = new ArrayList<String>();
            ArrayList urls = new ArrayList();
            sessions.add("session0");
            projects.add("project0");
            DownloaderApplet.this.m_Files.add(new Object[]{"NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\RAW\\1.MR.head_DHead.3.1.20070829.104546.718000.3532218994.dcm.gz", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/RAW/1.MR.head_DHead.3.1.20070829.104546.718000.3532218994.dcm.gz", new Long(43154L)});
            DownloaderApplet.this.m_TotalSize = DownloaderApplet.this.m_TotalSize + 43154L;
            DownloaderApplet.this.m_Files.add(new Object[]{"NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\scan_3_catalog.xml", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/scan_3_catalog.xml", new Long(1294L)});
            DownloaderApplet.this.m_TotalSize = DownloaderApplet.this.m_TotalSize + 1294L;
            DownloaderApplet.this.m_Files.add(new Object[]{"NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\RAW\\1.MR.head_DHead.3.3.20070829.104546.718000.9365419002.dcm.gz", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/RAW/1.MR.head_DHead.3.3.20070829.104546.718000.9365419002.dcm.gz", new Long(37872L)});
            DownloaderApplet.this.m_TotalSize = DownloaderApplet.this.m_TotalSize + 37872L;
            DownloaderApplet.this.m_Files.add(new Object[]{"NILPC154_TEST2\\arc001\\NILPC154_TEST2_4_1\\scan_3_catalog.xml", "http://localhost:8080/1.4/NILPC154_TEST2/arc001/NILPC154_TEST2_4_1/scan_3_catalog.xml", new Long(1294L)});
            DownloaderApplet.this.m_TotalSize = DownloaderApplet.this.m_TotalSize + 1294L;
            return true;
        }

        public void LoadImages(CatCatalogBean cat) throws MalformedURLException {
            for (Object sub : cat.getSets_entryset()) {
                CatCatalogBean catalog = (CatCatalogBean)sub;
                this.LoadImages(catalog);
            }
            for (Object sub : cat.getEntries_entry()) {
                CatEntryBean entry = (CatEntryBean)sub;
                String format = entry.getFormat();
                if (format != null && format.equals("CATALOG")) {
                    System.out.println("Loading sub-catalog:" + entry.getUri());
                    XDATXMLReader reader = new XDATXMLReader();
                    URL catalogURL = DownloaderApplet.buildUrl(entry.getUri());
                    try {
                        URLConnection connection = catalogURL.openConnection();
                        DownloaderApplet.this.jsessionidCookie.setInRequestHeader(connection);
                        BaseElement bean = reader.parse(connection.getInputStream());
                        if (!(bean instanceof CatCatalogBean)) continue;
                        this.LoadImages((CatCatalogBean)bean);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (format != null && format.equals("ZIP")) {
                    Object[] s = new Object[]{"ZIP", entry.getUri(), new Long(-1L)};
                    DownloaderApplet.this.AddFileToQueue(s);
                    if (DownloaderApplet.this.m_SessionStatus == 0) {
                        DownloaderApplet.this.m_SessionStatus = 1;
                        DownloaderApplet.this.AllowFolderSelection(true);
                        DownloaderApplet.this.UpdateStatus("Select local folder.");
                    }
                    ++this.nSessions;
                    continue;
                }
                String relative = entry.getCachepath();
                Long size = null;
                for (int i = 0; i < entry.getMetafields_metafield().size(); ++i) {
                    CatEntryMetafieldBean meta = (CatEntryMetafieldBean)entry.getMetafields_metafield().get(i);
                    if (!meta.getName().equals("SIZE")) continue;
                    String s = meta.getMetafield();
                    size = Long.valueOf(s);
                }
                Object[] s = new Object[]{relative, entry.getUri(), size};
                DownloaderApplet.this.AddFileToQueue(s);
                if (DownloaderApplet.this.m_SessionStatus == 0) {
                    DownloaderApplet.this.m_SessionStatus = 1;
                    DownloaderApplet.this.AllowFolderSelection(true);
                    DownloaderApplet.this.UpdateStatus("Select local folder.");
                }
                ++this.nSessions;
            }
        }

        public boolean InitSession() {
            if (this.TestFunction()) {
                DownloaderApplet.this.m_SessionStatus = 1;
                DownloaderApplet.this.AllowFolderSelection(true);
                DownloaderApplet.this.UpdateStatus("Select local folder.");
                return true;
            }
            boolean bRes = true;
            ArrayList<String> sessions = new ArrayList<String>();
            ArrayList urls = new ArrayList();
            int counter = 0;
            while (DownloaderApplet.this.getParameter("session" + counter) != null) {
                sessions.add(DownloaderApplet.this.getParameter("session" + counter++));
            }
            String user = DownloaderApplet.this.getParameter("user");
            for (int j = 0; j < sessions.size(); ++j) {
                String session = (String)sessions.get(j);
                XDATXMLReader reader = new XDATXMLReader();
                try {
                    URL catalogURL = DownloaderApplet.buildUrl(session);
                    URLConnection connection = catalogURL.openConnection();
                    DownloaderApplet.this.jsessionidCookie.setInRequestHeader(connection);
                    BaseElement bean = reader.parse(connection.getInputStream());
                    if (!(bean instanceof CatCatalogBean)) continue;
                    this.LoadImages((CatCatalogBean)bean);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    bRes = false;
                }
            }
            return bRes || this.nSessions > 0;
        }
    }
}

