/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathConstants;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;
import org.restlet.util.NodeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlRepresentation
extends OutputRepresentation
implements NamespaceContext {
    private volatile boolean namespaceAware = false;
    private volatile Map<String, String> namespaces = null;

    public static SAXSource getSaxSource(Representation xmlRepresentation) throws IOException {
        SAXSource result = null;
        if (xmlRepresentation != null) {
            result = new SAXSource(new InputSource(xmlRepresentation.getStream()));
            if (xmlRepresentation.getIdentifier() != null) {
                result.setSystemId(xmlRepresentation.getIdentifier().getTargetRef().toString());
            }
        }
        return result;
    }

    private static Schema getSchema(Representation schemaRepresentation) throws Exception {
        Schema result = null;
        if (schemaRepresentation != null) {
            StreamSource streamSource = new StreamSource(schemaRepresentation.getStream());
            result = SchemaFactory.newInstance(XmlRepresentation.getSchemaLanguageUri(schemaRepresentation)).newSchema(streamSource);
        }
        return result;
    }

    private static String getSchemaLanguageUri(Representation schemaRepresentation) {
        String result = null;
        if (schemaRepresentation != null) {
            if (MediaType.APPLICATION_W3C_SCHEMA_XML.equals(schemaRepresentation.getMediaType())) {
                result = "http://www.w3.org/2001/XMLSchema";
            } else if (MediaType.APPLICATION_RELAXNG_COMPACT.equals(schemaRepresentation.getMediaType())) {
                result = "http://relaxng.org/ns/structure/1.0";
            } else if (MediaType.APPLICATION_RELAXNG_XML.equals(schemaRepresentation.getMediaType())) {
                result = "http://relaxng.org/ns/structure/1.0";
            }
        }
        return result;
    }

    public XmlRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public XmlRepresentation(MediaType mediaType, long expectedSize) {
        super(mediaType, expectedSize);
    }

    public abstract Object evaluate(String var1, QName var2) throws Exception;

    public Boolean getBoolean(String expression) {
        return (Boolean)this.internalEval(expression, XPathConstants.BOOLEAN);
    }

    protected DocumentBuilder getDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(this.isNamespaceAware());
            dbf.setValidating(false);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Couldn't create the empty document: " + pce.getMessage());
        }
    }

    public DOMSource getDomSource() throws IOException {
        DOMSource result = null;
        Document document = null;
        try {
            document = this.getDocumentBuilder().parse(this.getStream());
        }
        catch (SAXException se) {
            throw new IOException("Couldn't read the XML representation. " + se.getMessage());
        }
        if (document != null) {
            result = new DOMSource(document);
            if (this.getIdentifier() != null) {
                result.setSystemId(this.getIdentifier().getTargetRef().toString());
            }
        }
        return result;
    }

    private Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        return this.namespaces;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    public Node getNode(String expression) {
        return (Node)this.internalEval(expression, XPathConstants.NODE);
    }

    public NodeSet getNodes(String expression) {
        NodeList nodes = (NodeList)this.internalEval(expression, XPathConstants.NODESET);
        return nodes == null ? null : new NodeSet(nodes);
    }

    public Double getNumber(String expression) {
        return (Double)this.internalEval(expression, XPathConstants.NUMBER);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String result = null;
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            if (result != null || !entry.getValue().equals(namespaceURI)) continue;
            result = entry.getKey();
        }
        return result;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            result.add(entry.getKey());
        }
        return Collections.unmodifiableList(result).iterator();
    }

    public SAXSource getSaxSource() throws IOException {
        return XmlRepresentation.getSaxSource(this);
    }

    public StreamSource getStreamSource() throws IOException {
        StreamSource result = new StreamSource(this.getStream());
        if (this.getIdentifier() != null) {
            result.setSystemId(this.getIdentifier().getTargetRef().toString());
        }
        return result;
    }

    public String getText(String expression) {
        return (String)this.internalEval(expression, XPathConstants.STRING);
    }

    private Object internalEval(String expression, QName returnType) {
        try {
            return this.evaluate(expression, returnType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void putNamespace(String prefix, String namespaceURI) {
        this.getNamespaces().put(prefix, namespaceURI);
    }

    @Override
    public void release() {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this.namespaces = null;
        }
        super.release();
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void validate(Representation schemaRepresentation) throws Exception {
        this.validate(schemaRepresentation, null);
    }

    public void validate(Representation schemaRepresentation, Result result) throws Exception {
        this.validate(XmlRepresentation.getSchema(schemaRepresentation), result);
    }

    public void validate(Schema schema) throws Exception {
        this.validate(schema, null);
    }

    public void validate(Schema schema, Result result) throws Exception {
        schema.newValidator().validate(this.getSaxSource(), result);
    }
}

