/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.edit;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nrg.ecat.edit.ScriptEvaluationException;
import org.nrg.ecat.edit.ScriptFunction;
import org.nrg.ecat.edit.Value;

public abstract class AbstractIndexedLabelFunction
implements ScriptFunction {
    protected abstract boolean isAvailable(String var1) throws ScriptEvaluationException;

    private final Value getFormat(List values) throws ScriptEvaluationException {
        try {
            return (Value)values.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                throw new ScriptEvaluationException(this.getClass().getField("name").get(null) + " requires format argument");
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException(e1);
            }
            catch (SecurityException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public Value apply(List args) throws ScriptEvaluationException {
        final Value format = this.getFormat(args);
        return new Value(){

            private NumberFormat buildFormatter(int len) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    sb.append("0");
                }
                return new DecimalFormat(sb.toString());
            }

            private String valueFor(Object fo) throws ScriptEvaluationException {
                int offset;
                String format2 = fo.toString();
                int end = offset = format2.indexOf(35);
                while ('#' == format2.charAt(end)) {
                    ++end;
                }
                NumberFormat nf = this.buildFormatter(end - offset);
                StringBuffer sb = new StringBuffer(format2);
                int i = 0;
                String label;
                while (!AbstractIndexedLabelFunction.this.isAvailable(label = sb.replace(offset, end, nf.format(i)).toString())) {
                    ++i;
                }
                return label;
            }

            public Object on(Map m) throws ScriptEvaluationException {
                return this.valueFor(format.on(m));
            }

            public Set getVariables() {
                return format.getVariables();
            }
        };
    }
}

