/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nrg.ecat.edit.ConstantValue;
import org.nrg.ecat.edit.ScriptEvaluationException;
import org.nrg.ecat.edit.Value;

public class MessageFormatValue
implements Value {
    private final Value format;
    private final List values;
    private final Set variables;

    public MessageFormatValue(Value format, Collection values) {
        this.format = format;
        this.values = new ArrayList(values);
        LinkedHashSet tv = new LinkedHashSet();
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            Value v = (Value)i.next();
            tv.addAll(v.getVariables());
        }
        this.variables = Collections.unmodifiableSet(tv);
    }

    public MessageFormatValue(String format, Collection values) {
        this(new ConstantValue(format), values);
    }

    public Set getVariables() {
        return this.variables;
    }

    public Object on(Map m) throws ScriptEvaluationException {
        Object[] vals = new Object[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            vals[i] = ((Value)this.values.get(i)).on(m);
        }
        Object f = this.format.on(m);
        return MessageFormat.format(null == f ? "" : f.toString(), vals);
    }
}

