/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.edit;

import org.nrg.ecat.edit.MultipleInitializationException;
import org.nrg.ecat.edit.Value;
import org.nrg.ecat.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptReferencedVariable
implements Variable {
    private final Logger logger = LoggerFactory.getLogger((Class)ScriptReferencedVariable.class);
    private final String name;
    private Object value = null;
    private Value initValue = null;
    private boolean isHidden = false;
    private String description = null;
    private String exportField = null;

    public ScriptReferencedVariable(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExportField() {
        return this.exportField;
    }

    public Value getInitialValue() {
        return this.initValue;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExportField(String exportField) {
        this.exportField = exportField;
    }

    public void setInitialValue(Value value) throws MultipleInitializationException {
        if (null != this.initValue) {
            throw new MultipleInitializationException(this, value);
        }
        this.logger.trace("{} initial value set to {}", (Object)this, (Object)value);
        this.initValue = value;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setValue(Object value) {
        this.logger.trace("{} value set to {}", (Object)this, value);
        this.value = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        return sb.append(" (").append(this.name).append(")").toString();
    }
}

