/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class FileWalkIterator
implements Iterator<File> {
    private static final File NEXT_NOT_CALLED = null;
    private final Logger logger = LoggerFactory.getLogger(FileWalkIterator.class);
    private final File root;
    private final Queue<File> queue = new LinkedList<File>();
    private File current = NEXT_NOT_CALLED;
    private int count;

    public FileWalkIterator(File root) {
        this.root = root;
        for (String child : root.list()) {
            this.queue.offer(new File(child));
        }
    }

    private synchronized void prepareQueue() {
        while (!this.queue.isEmpty()) {
            File relative = this.queue.peek();
            File resolved = new File(this.root, relative.getPath());
            if (resolved.isDirectory()) {
                this.queue.remove();
                for (String name : resolved.list()) {
                    File rf = new File(resolved, name);
                    try {
                        File cf = rf.getCanonicalFile();
                        if (cf.isDirectory()) {
                            if (cf.getPath().equalsIgnoreCase(rf.getAbsolutePath())) {
                                this.queue.add(new File(relative, name));
                                continue;
                            }
                            this.logger.info("Skipping possible symbolic link {}", (Object)cf);
                            continue;
                        }
                        this.queue.add(new File(relative, name));
                    }
                    catch (IOException e) {
                        this.logger.error("Unable to determine canonical path", (Throwable)e);
                    }
                }
                continue;
            }
            return;
        }
    }

    @Override
    public boolean hasNext() {
        this.prepareQueue();
        return !this.queue.isEmpty();
    }

    @Override
    public File next() {
        this.prepareQueue();
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        ++this.count;
        this.current = this.queue.remove();
        return this.current;
    }

    @Override
    public void remove() {
        if (NEXT_NOT_CALLED == this.current) {
            throw new IllegalStateException("next() not called");
        }
        assert (!this.current.isDirectory());
        try {
            new File(this.root, this.current.getPath()).delete();
        }
        catch (SecurityException e) {
            this.logger.error("unable to remove " + this.current, (Throwable)e);
        }
        this.current = NEXT_NOT_CALLED;
    }

    public int getCount() {
        return this.count;
    }
}

