/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphUtils {
    private GraphUtils() {
    }

    public static <X> List<X> topologicalSort(Map<X, Collection<X>> graph) throws CyclicGraphException {
        LinkedHashSet<X> resolved = new LinkedHashSet<X>();
        Iterator<Map.Entry<X, Collection<X>>> mei = graph.entrySet().iterator();
        while (mei.hasNext()) {
            Map.Entry<X, Collection<X>> me = mei.next();
            X node = me.getKey();
            Collection<X> edges = me.getValue();
            edges.remove(node);
            if (!edges.isEmpty()) continue;
            resolved.add(node);
            mei.remove();
        }
        ArrayList sorted = new ArrayList(graph.size());
        while (!resolved.isEmpty()) {
            Iterator i = resolved.iterator();
            Object x = i.next();
            i.remove();
            sorted.add(x);
            Iterator<Map.Entry<X, Collection<X>>> mei2 = graph.entrySet().iterator();
            while (mei2.hasNext()) {
                Map.Entry<X, Collection<X>> me = mei2.next();
                Collection<X> incoming = me.getValue();
                incoming.remove(x);
                if (!incoming.isEmpty()) continue;
                resolved.add(me.getKey());
                mei2.remove();
            }
        }
        if (graph.isEmpty()) {
            return sorted;
        }
        throw new CyclicGraphException("some nodes are in cyclic graph: " + graph.keySet(), sorted);
    }

    public static class CyclicGraphException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final Object partial;

        CyclicGraphException(String msg, Object partial) {
            super(msg);
            this.partial = partial;
        }

        CyclicGraphException(Object partial) {
            this.partial = partial;
        }

        public Object getPartialResult() {
            return this.partial;
        }
    }
}

