/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Set;
import javax.swing.JOptionPane;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.TextDicomVariable;
import org.nrg.dcm.edit.MultipleInitializationException;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.nrg.upload.data.AbstractSessionVariable;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.ValueListener;

public abstract class DicomSessionVariable
extends AbstractSessionVariable
implements SessionVariable,
ValueListener {
    private final Variable v;
    private final DicomObject sample;
    private String message = null;

    public static DicomSessionVariable getSessionVariable(Variable v, DicomObject sample) {
        return new TextDicomVariable(v, sample);
    }

    DicomSessionVariable(Variable v, DicomObject sample) {
        super(v.getName());
        this.sample = sample;
        this.v = v;
    }

    @Override
    public String getDescription() {
        String description = this.v.getDescription();
        return Strings.isNullOrEmpty((String)description) ? this.v.getName() : description;
    }

    @Override
    public String getExportField() {
        return this.v.getExportField();
    }

    @Override
    public String getValue() {
        String value = this.v.getValue();
        if (null == value) {
            Value iv = this.v.getInitialValue();
            if (null == iv) {
                return null;
            }
            try {
                return iv.on(this.sample);
            }
            catch (ScriptEvaluationException e) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("An serious error was encountered while preparing the DICOM.\n");
                errorMessage.append("Please contact your site administrator with the following error\n");
                errorMessage.append("message before uploading this data, as it could contain incorrect data.\n\n");
                errorMessage.append(e.getMessage());
                JOptionPane.showMessageDialog(null, errorMessage.toString(), "DICOM Script Error", 0);
                return null;
            }
        }
        return value;
    }

    @Override
    public String getValueMessage() {
        return this.message;
    }

    public Variable getVariable() {
        return this.v;
    }

    protected void editTo(String value) {
        try {
            this.message = this.validate(value);
            this.v.setValue(value);
            this.fireHasChanged();
        }
        catch (SessionVariable.InvalidValueException e) {
            this.fireIsInvalid(this.v, e.getMessage());
        }
    }

    @Override
    public boolean isHidden() {
        return this.v.isHidden();
    }

    @Override
    public String setDescription(String description) {
        if (Strings.isNullOrEmpty((String)this.v.getDescription())) {
            return super.setDescription(description);
        }
        return this.v.getDescription();
    }

    public void setIsHidden(boolean isHidden) {
        this.v.setIsHidden(isHidden);
    }

    @Override
    public String setValue(String value) throws SessionVariable.InvalidValueException {
        this.message = this.validate(value);
        String old = this.v.getValue();
        this.v.setValue(value);
        return old;
    }

    public void setInitialValue(Value value) throws MultipleInitializationException {
        this.v.setInitialValue(value);
    }

    public boolean hasInitialValue() {
        return null != this.v.getInitialValue();
    }

    public Set<?> getTags() {
        Value iv = this.v.getInitialValue();
        return null == iv ? Collections.emptySet() : iv.getTags();
    }

    public Set<?> getVariables() {
        Value iv = this.v.getInitialValue();
        return null == iv ? Collections.emptySet() : iv.getVariables();
    }

    @Override
    public void hasChanged(SessionVariable variable) {
        this.fireHasChanged();
    }

    @Override
    public void isInvalid(SessionVariable variable, Object value, String message) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/").append(this.v);
        sb.append(" ").append(this.getName()).append(" = ").append(this.getValue());
        sb.append(" [init ").append(this.v.getInitialValue()).append("]");
        return sb.toString();
    }
}

