/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.Entity;
import org.nrg.dcm.MapEntity;
import org.nrg.dcm.SOPModel;
import org.nrg.dcm.Study;

public class Series
extends MapEntity
implements Entity,
Comparable<Series>,
Iterable<File> {
    private final Study study;
    private final Multimap<String, String> sopToTS = LinkedHashMultimap.create();
    private final Set<String> modalities = Sets.newTreeSet();
    private final Set<File> files = Sets.newLinkedHashSet();
    private DicomObject sampleObject = null;
    private boolean uploadAllowed = true;

    Series(Study study, String uid, int number, String modality) {
        this.study = study;
        this.put(0x20000E, (Object)uid);
        this.put(0x200011, (Object)number);
        this.modalities.add(modality);
    }

    Series(Study study, DicomObject o) {
        this(study, o.getString(0x20000E), o.getInt(0x200011), o.getString(524384));
        if (null == this.sampleObject) {
            this.sampleObject = o;
        }
    }

    public void addFile(File f, DicomObject o) {
        if (null == this.sampleObject) {
            this.sampleObject = o;
        }
        this.sopToTS.put((Object)o.getString(524310), (Object)DicomUtils.getTransferSyntaxUID((DicomObject)o));
        this.files.add(f);
    }

    private int compareObject(Comparable a, Comparable b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(Series o) {
        Integer n = (Integer)this.get(0x200011);
        Integer on = (Integer)o.get(0x200011);
        if (0 == this.compareObject((Comparable)((Object)((String)this.get(0x20000E))), (Comparable)((Object)((String)o.get(0x20000E))))) {
            return this.compareObject(n, on);
        }
        return this.compareObject((Comparable)((Object)((String)this.get(0x20000E))), (Comparable)((Object)((String)o.get(0x20000E))));
    }

    public int getFileCount() {
        return this.files.size();
    }

    public Collection<File> getFiles() {
        return Collections.unmodifiableCollection(this.files);
    }

    public Set<String> getModalities() {
        return Collections.unmodifiableSet(this.modalities);
    }

    final String getNumber() {
        Object n = this.get(0x200011);
        return null == n ? null : n.toString();
    }

    final String getUID() {
        return (String)this.get(0x20000E);
    }

    public DicomObject getSampleObject() {
        return this.sampleObject;
    }

    public String getScanType() {
        return SOPModel.getScanType((Iterable)this.sopToTS.keySet());
    }

    @Override
    public Collection<Series> getSeries() {
        return Collections.singleton(this);
    }

    public long getSize() {
        long size = 0L;
        for (File f : this.files) {
            size += f.length();
        }
        return size;
    }

    public Set<String> getSOPClassUIDs() {
        return Collections.unmodifiableSet(this.sopToTS.keySet());
    }

    @Override
    public Collection<Study> getStudies() {
        return Collections.singleton(this.study);
    }

    public Set<String> getTransferSyntaxUIDs() {
        return new LinkedHashSet<String>(this.sopToTS.values());
    }

    public Multimap<String, String> addTransferCapabilityComponents(Multimap<String, String> m) {
        m.putAll(this.sopToTS);
        return m;
    }

    @Override
    public Iterator<File> iterator() {
        return Collections.unmodifiableSet(this.files).iterator();
    }

    public boolean equals(Object o) {
        return o instanceof Series && this.getAttributes().equals(((Entity)o).getAttributes());
    }

    @Override
    public int hashCode() {
        return this.getAttributes().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Series ");
        sb.append(this.getNumber());
        return sb.toString();
    }

    public void setUploadAllowed(boolean uploadAllowed) {
        this.uploadAllowed = uploadAllowed;
    }

    public boolean isUploadAllowed() {
        return this.uploadAllowed;
    }
}

