/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomSessionVariable;
import org.nrg.dcm.edit.Variable;
import org.nrg.upload.data.SessionVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextDicomVariable
extends DicomSessionVariable
implements DocumentListener {
    private final Logger logger = LoggerFactory.getLogger(TextDicomVariable.class);
    private final JTextField text;

    TextDicomVariable(Variable v, DicomObject sample) {
        super(v, sample);
        this.text = new JTextField(v.getValue());
        this.text.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }

    @Override
    public JTextField getEditor() {
        return this.text;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }

    @Override
    public void refresh() {
        this.setDisplayValue(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setDisplayValue(String value) {
        String old = this.text.getText();
        Document d = this.text.getDocument();
        TextDicomVariable textDicomVariable = this;
        synchronized (textDicomVariable) {
            d.removeDocumentListener(this);
            this.logger.trace("Setting text field for " + this.getName() + " = " + value);
            this.text.setText(value);
            d.addDocumentListener(this);
        }
        return old;
    }

    @Override
    public String setValue(String value) throws SessionVariable.InvalidValueException {
        String old = super.setValue(value);
        this.setDisplayValue(value);
        return old;
    }
}

