/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.nrg.dcm.Study;
import org.nrg.ecat.EcatSessionVariable;
import org.nrg.ecat.MatrixDataFile;
import org.nrg.ecat.ModifyingUploadProcessor;
import org.nrg.ecat.edit.ScriptApplicator;
import org.nrg.ecat.edit.Variable;
import org.nrg.net.HttpException;
import org.nrg.net.JSONRequestConnectionProcessor;
import org.nrg.net.RestServer;
import org.nrg.upload.data.AssignedSessionVariable;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Session;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.Subject;
import org.nrg.upload.data.UploadFailureHandler;
import org.nrg.upload.ui.UploadResultPanel;
import org.nrg.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EcatSession
implements Session {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String FORMAT = "ECAT";
    private static final String MODALITY = "PET";
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd_HHmmss";
    private final Logger logger = LoggerFactory.getLogger(EcatSession.class);
    private final MatrixDataFile first;
    private final Collection<MatrixDataFile> data;
    private long size = 0L;
    private TimeZone timeZone = null;
    private static final String[] timezones = new String[]{System.getProperty("user.timezone"), "America/New_York", "America/Chicago", "America/Los_Angeles", "Pacific/Midway", "US/Hawaii", "US/Alaska", "US/Pacific", "America/Tijuana", "US/Arizona", "America/Chihuahua", "US/Mountain", "America/Guatemala", "US/Central", "America/Mexico_City", "Canada/Saskatchewan", "America/Bogota", "US/Eastern", "US/East-Indiana", "Canada/Eastern", "America/Caracas", "America/Manaus", "America/Santiago", "Canada/Newfoundland", "Brazil/East", "America/Buenos_Aires", "America/Godthab", "America/Montevideo", "Atlantic/South_Georgia", "Atlantic/Azores", "Atlantic/Cape_Verde", "Africa/Casablanca", "Europe/London", "Europe/Berlin", "Europe/Belgrade", "Europe/Brussels", "Europe/Warsaw", "Africa/Algiers", "Asia/Amman", "Europe/Athens", "Asia/Beirut", "Africa/Cairo", "Africa/Harare", "Europe/Helsinki", "Asia/Jerusalem", "Europe/Minsk", "Africa/Windhoek", "Asia/Baghdad", "Asia/Kuwait", "Europe/Moscow", "Africa/Nairobi", "Asia/Tbilisi", "Asia/Tehran", "Asia/Muscat", "Asia/Baku", "Asia/Yerevan", "Asia/Kabul", "Asia/Yekaterinburg", "Asia/Karachi", "Asia/Calcutta", "Asia/Colombo", "Asia/Katmandu", "Asia/Novosibirsk", "Asia/Dhaka", "Asia/Rangoon", "Asia/Bangkok", "Asia/Krasnoyarsk", "Asia/Hong_Kong", "Asia/Irkutsk", "Asia/Kuala_Lumpur", "Australia/Perth", "Asia/Taipei", "Asia/Tokyo", "Asia/Seoul", "Asia/Yakutsk", "Australia/Adelaide", "Australia/Darwin", "Australia/Brisbane", "Australia/Sydney", "Pacific/Guam", "Australia/Hobart", "Asia/Vladivostok", "Asia/Magadan", "Pacific/Auckland", "Pacific/Fiji", "Pacific/Tongatapu"};

    public EcatSession(Collection<MatrixDataFile> files) {
        ArrayList list = Lists.newArrayList(files);
        Collections.sort(list);
        this.first = files.isEmpty() ? null : (MatrixDataFile)list.get(0);
        this.data = Collections.unmodifiableCollection(list);
    }

    @Override
    public String getAccession() {
        return null;
    }

    @Override
    public Date getDateTime() {
        if (this.timeZone == null) {
            JComboBox<String> list = new JComboBox<String>(timezones);
            JPanel panel = new JPanel();
            JLabel l = new JLabel("Select the Time Zone in which this scan was acquired");
            panel.add(l);
            panel.add(list);
            JOptionPane.showMessageDialog(null, panel, "Select the Time Zone in which this scan was acquired", -1);
            this.timeZone = TimeZone.getTimeZone(timezones[list.getSelectedIndex()]);
        }
        DateTime original = new DateTime(this.first.getDate().getTime());
        DateTime zoned = original.withZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        return zoned.toDate();
    }

    @Override
    public String getDescription() {
        return this.first.getDescription();
    }

    @Override
    public int getFileCount() {
        return this.data.size();
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public String getID() {
        return this.first.getPatientID();
    }

    @Override
    public Set<String> getModalities() {
        return Collections.singleton(MODALITY);
    }

    @Override
    public int getScanCount() {
        return this.data.size();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public long getSize() {
        if (0L == this.size) {
            for (MatrixDataFile f : this.data) {
                this.size += f.getSize();
            }
        }
        return this.size;
    }

    @Override
    public List<SessionVariable> getVariables(Map<?, ?> params) {
        List evs;
        Project project = (Project)params.get("project");
        try {
            ScriptApplicator applicator = project.getEcatScriptApplicator();
            if (null == applicator) {
                this.logger.info("no script available");
                return Collections.emptyList();
            }
            evs = applicator.getSortedVariables();
        }
        catch (Throwable t) {
            this.logger.warn("unable to load script applicator", t);
            return Collections.emptyList();
        }
        ArrayList sessionVars = Lists.newArrayList();
        sessionVars.add(new AssignedSessionVariable("modalityLabel", MODALITY, true));
        for (Variable ev : evs) {
            sessionVars.add(EcatSessionVariable.getSessionVariable(ev));
        }
        return sessionVars;
    }

    public String toString() {
        String description;
        String accessionNumber;
        Date sessionDate = this.getDateTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm z");
        if (this.timeZone != null) {
            sdf.setTimeZone(this.timeZone);
        }
        StringBuilder builder = new StringBuilder("ECAT study ");
        String studyId = this.getID();
        if (null != studyId) {
            builder.append(studyId);
        }
        if (null != (accessionNumber = this.getAccession())) {
            builder.append(" (").append((Object)accessionNumber).append(")");
        }
        if (null != sessionDate) {
            builder.append(" ").append(sdf.format(sessionDate));
        }
        if (null != (description = this.getDescription())) {
            builder.append(" ").append((Object)description);
        }
        if (null == studyId && null == accessionNumber) {
            builder.append(" [NO ECAT ID]");
        }
        return builder.toString();
    }

    private static String makeTimestamp() {
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date());
    }

    @Override
    public boolean uploadTo(Map<?, ?> params, UploadFailureHandler failureHandler, ResultProgressHandle progress) {
        if (this.data.isEmpty()) {
            progress.failed("No ECAT files available to upload", true);
            return false;
        }
        Project project = (Project)params.get("project");
        Subject subject = (Subject)params.get("subject");
        SessionVariable session = (SessionVariable)params.get("session");
        String sessionID = session.getValue();
        String visit = null;
        if (params.get("*visit*") != null) {
            visit = ((SessionVariable)params.get("*visit*")).getValue();
        }
        String protocol = null;
        if (params.get("*protocol*") != null) {
            protocol = ((SessionVariable)params.get("*protocol*")).getValue();
        }
        String timestamp = EcatSession.makeTimestamp();
        RestServer xnat = project.getRestServer();
        String sessionLabel = session.getValue();
        progress.setBusy("Creating session " + sessionLabel);
        StringBuffer path = new StringBuffer(String.format("/data/services/import?dest=/prearchive/projects/%s/%s/%s", project, timestamp, session.getValue()));
        if (!Strings.isNullOrEmpty((String)visit)) {
            path.append("&VISIT=").append(visit);
        }
        if (!Strings.isNullOrEmpty((String)protocol)) {
            path.append("&PROTOCOL=").append(protocol);
        }
        if (!Strings.isNullOrEmpty((String)this.timeZone.getID())) {
            path.append("&TIMEZONE=").append(this.timeZone.getID());
        }
        path.append("&SOURCE=applet");
        int i = 0;
        int size = this.data.size();
        Iterator<MatrixDataFile> iterator = this.data.iterator();
        block2: while (iterator.hasNext()) {
            MatrixDataFile dataFile = iterator.next();
            File f = dataFile.getFile();
            while (true) {
                try {
                    String scan = String.format("%s&SUBJECT_ID=%s&overwrite=append&xnat:petSessionData/scans/scan/ID=%d", path, subject.getLabel(), ++i);
                    progress.setProgress(String.format("Uploading scan %d/%d", i, size), i - 1, size);
                    ModifyingUploadProcessor processor = new ModifyingUploadProcessor(f, progress, project.toString(), subject.getLabel(), sessionID);
                    this.logger.trace("uploading {} as scan {}", (Object)f, (Object)i);
                    long start = new Date().getTime();
                    xnat.doPost(scan, processor);
                    this.logger.trace("upload successful: {} bytes in {} seconds", (Object)size, (Object)((new Date().getTime() - start) / 1000L));
                    continue block2;
                }
                catch (Throwable t) {
                    if (failureHandler.shouldRetry(dataFile.getFile(), t)) {
                        this.logger.info("upload failed, retrying", t);
                        continue;
                    }
                    LinkedHashMap failures = Maps.newLinkedHashMap();
                    failures.put(f, t);
                    StringBuilder message = new StringBuilder("user canceled operation after errors:");
                    message.append(LINE_SEPARATOR);
                    EcatSession.buildFailureMessage(message, failures);
                    progress.failed(message.toString(), true);
                    while (iterator.hasNext()) {
                        failures.put(iterator.next().getFile(), this.getUserCanceledFailure());
                    }
                    return false;
                }
                break;
            }
        }
        HashMap failures = Maps.newHashMap();
        this.closeSession(String.format("/data/prearchive/projects/%s/%s/%s", project, timestamp, session.getValue()), params, progress, failures);
        return true;
    }

    private JSONObject buildCommitEntity(Map<?, ?> params) {
        JSONObject entity = new JSONObject();
        Collection vars = (Collection)params.get("*session-variables*");
        if (null == vars) {
            this.logger.error("session variables not assigned in {}", params);
        } else {
            for (Object o : vars) {
                SessionVariable v;
                String path;
                if (!(o instanceof SessionVariable) || Strings.isNullOrEmpty((String)(path = (v = (SessionVariable)o).getExportField()))) continue;
                try {
                    entity.put(path, (Object)v.getValue());
                }
                catch (JSONException exception) {
                    String message = "unable to assign session variable " + path;
                    this.logger.error(message, (Throwable)exception);
                }
            }
        }
        this.logger.trace("Built commit entity: {}", (Object)entity);
        return entity;
    }

    private boolean closeSession(String path, Map<?, ?> params, ResultProgressHandle progress, Map<?, ?> failures) {
        String adminEmail = (String)params.get("*xnat-admin-email*");
        String session = ((SessionVariable)params.get("session")).getValue();
        RestServer xnat = (RestServer)params.get("*xnat-rest-server*");
        try {
            if (failures.isEmpty()) {
                progress.setBusy("Committing session");
                this.logger.trace("committing session {}", (Object)path);
                JSONRequestConnectionProcessor handler = new JSONRequestConnectionProcessor(this.buildCommitEntity(params));
                String queryParams = "?action=commit&SOURCE=applet";
                if (null != params.get("*visit*") && !Strings.isNullOrEmpty((String)((AssignedSessionVariable)params.get("*visit*")).getValue())) {
                    queryParams = queryParams + "&VISIT=" + ((AssignedSessionVariable)params.get("*visit*")).getValue();
                }
                if (null != params.get("*protocol*") && !Strings.isNullOrEmpty((String)((AssignedSessionVariable)params.get("*protocol*")).getValue())) {
                    queryParams = queryParams + "&PROTOCOL=" + ((AssignedSessionVariable)params.get("*protocol*")).getValue();
                }
                if (null != this.timeZone) {
                    queryParams = queryParams + "&TIMEZONE=" + this.timeZone.getID();
                }
                xnat.doPost(path + queryParams, handler);
                String response = handler.getResponseEntity();
                String resultPath = Study.getWebAppRelativePath(xnat.getURL(), response);
                URL result = new URL(xnat.getURL() + "/" + resultPath);
                UploadResultPanel resultPanel = new UploadResultPanel(session, Study.buildSessionViewURL(result, resultPath));
                progress.finished((Object)Summary.create((Component)resultPanel, (Object)path));
                return true;
            }
            progress.failed(Study.buildFailureMessage(failures), false);
            return false;
        }
        catch (JSONException e) {
            this.logger.error("unable to write commit request entity", (Throwable)e);
            return false;
        }
        catch (HttpException e) {
            this.logger.error("session commit failed", (Throwable)e);
            switch (e.getResponseCode()) {
                case 404: {
                    StringBuilder sb = new StringBuilder("<h3>Resource not found (404)</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, xnat);
                    sb.append(" is accessible but reports that the session resource ");
                    sb.append(path);
                    sb.append(" does not exist.</p>");
                    sb.append("<p>Contact the administrator ");
                    sb.append("<").append(adminEmail).append(">");
                    sb.append(" for help.</p>");
                    progress.failed(sb.toString(), true);
                    return false;
                }
                case 500: {
                    StringBuilder sb = new StringBuilder("<h3>Internal Server Error (500)</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, xnat);
                    sb.append(" is accessible but was unable to commit the requested session");
                    sb.append(" due to an internal error.</p>");
                    sb.append("<p>Please contact the administrator ");
                    sb.append("<").append(adminEmail).append(">");
                    sb.append(" for help.");
                    sb.append(" A detailed description of the problem should be available");
                    sb.append(" in the DICOM receiver log or the XNAT logs.</p>");
                    progress.failed(sb.toString(), true);
                    return false;
                }
                case 409: {
                    StringBuilder sb = new StringBuilder("<h3>Session data conflict</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, xnat);
                    sb.append(" reports a conflict between the uploaded data and a session in the archive.</p>");
                    sb.append("<p>All or part of this session was previously uploaded. Go to the prearchive page ");
                    sb.append("to archive the data just uploaded as a new session, or to merge it into an existing session.");
                    progress.failed(sb.toString(), true);
                    return false;
                }
            }
            StringBuilder sb = new StringBuilder("<h3>Unexpected error ");
            sb.append(e.getResponseCode()).append(": ");
            sb.append(e.getMessage()).append("</h3>");
            sb.append("<p>Unable to commit uploaded session</p>");
            sb.append("<p>Please contact your XNAT administrator ");
            sb.append("<").append(adminEmail).append(">");
            sb.append(" for help.</p>");
            progress.failed(sb.toString(), true);
            return false;
        }
        catch (IOException e) {
            this.logger.error("Session commit failed", (Throwable)e);
            StringBuilder sb = new StringBuilder("<h3>Communications error</h3>");
            sb.append("<p>The server at ");
            Study.appendServer(sb, xnat);
            sb.append(" is inaccessible (");
            sb.append(e.getMessage());
            sb.append("). Please contact your XNAT administrator ");
            sb.append("<").append(adminEmail).append(">");
            sb.append(" for help.</p>");
            progress.failed(sb.toString(), false);
            return false;
        }
        catch (Throwable t) {
            this.logger.error("Session commit failed", t);
            StringBuilder sb = new StringBuilder("<h3>Error in applet</h3>");
            sb.append("<p>An error in the uploader (").append(t);
            sb.append(" prevented the session from being committed.");
            sb.append(" Please contact your XNAT administrator ");
            sb.append("<").append(adminEmail).append(">");
            sb.append(" for help.</p>");
            progress.failed(sb.toString(), false);
            return false;
        }
    }

    private Object getUserCanceledFailure() {
        return "User canceled upload";
    }

    private static <T> StringBuilder buildFailureMessage(StringBuilder sb, Map<File, T> failures) {
        LinkedHashMultimap inverse = LinkedHashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(failures), (Multimap)inverse);
        Multimap causes = Utils.consolidateKeys(inverse, 4);
        for (Object key : causes.keySet()) {
            Collection files = causes.get(key);
            sb.append(files.size()).append(" files not uploaded: ").append(key);
            sb.append(LINE_SEPARATOR);
        }
        return sb;
    }
}

