/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.nrg.ecat.edit.ScriptEvaluationException;
import org.nrg.ecat.edit.ScriptFunction;
import org.nrg.ecat.edit.Value;
import org.nrg.upload.data.Session;

public final class FormatSessionDateFunction
implements ScriptFunction {
    private static final String name = "formatSessionDate";
    private final Callable<Session> sessionSource;

    public FormatSessionDateFunction(Callable<Session> sessionSource) {
        this.sessionSource = sessionSource;
    }

    public Value apply(List args) throws ScriptEvaluationException {
        try {
            return new DelayedSessionDateValue((Value)args.get(0));
        }
        catch (Exception e) {
            throw new ScriptEvaluationException("unable to extract argument for function formatSessionDate", (Throwable)e);
        }
    }

    private final class DelayedSessionDateValue
    implements Value {
        private final Value fv;

        DelayedSessionDateValue(Value format) {
            this.fv = format;
        }

        public Set getVariables() {
            return this.fv.getVariables();
        }

        public String on(Map m) throws ScriptEvaluationException {
            Session session;
            String format = (String)this.fv.on(m);
            try {
                session = (Session)FormatSessionDateFunction.this.sessionSource.call();
            }
            catch (Exception e) {
                throw new ScriptEvaluationException("unable to retrieve session", (Throwable)e);
            }
            if (null == session) {
                return null;
            }
            Date d = session.getDateTime();
            return null == d ? null : new SimpleDateFormat(format).format(d);
        }
    }
}

