/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.nrg.ProgressListener;
import org.nrg.ecat.HeaderModification;
import org.nrg.ecat.MainHeader;
import org.nrg.ecat.MatrixData;
import org.nrg.ecat.var.Variable;
import org.nrg.net.HttpURLConnectionProcessor;
import org.nrg.upload.ui.ResultProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyingUploadProcessor
implements HttpURLConnectionProcessor {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE = "application/zip";
    private static final Variable[] toClear = new Variable[]{MainHeader.PATIENT_AGE, MainHeader.PATIENT_HEIGHT, MainHeader.PATIENT_WEIGHT, MainHeader.PATIENT_BIRTH_DATE};
    private final Logger logger = LoggerFactory.getLogger(ModifyingUploadProcessor.class);
    private final String name;
    private final InputStream in;
    private final int size;
    private final ResultProgressListener progress;
    private final Collection<HeaderModification> modifications;

    public ModifyingUploadProcessor(File f, ResultProgressHandle progress, String project, String subject, String session) throws IOException {
        this.in = new FileInputStream(f);
        this.size = (int)f.length();
        if (this.size < 0) {
            throw new UnsupportedOperationException("cannot upload files with size beyond integer range");
        }
        this.name = f.getName();
        this.progress = new ResultProgressListener(progress, 0, this.size);
        this.modifications = new ArrayList<HeaderModification>();
        this.modifications.add(MainHeader.STUDY_DESCRIPTION.createValueModification((Object)project));
        this.modifications.add(MainHeader.PATIENT_NAME.createValueModification((Object)subject));
        this.modifications.add(MainHeader.PATIENT_ID.createValueModification((Object)session));
        for (Variable v : toClear) {
            this.modifications.add(v.createClearModification());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void prepare(HttpURLConnection connection) throws IOException {
        File tempzip = File.createTempFile("scan-upload", ".zip");
        try {
            FileInputStream fis;
            IOException ioexception;
            block39: {
                this.logger.debug("creating zip file {}", (Object)tempzip);
                ioexception = null;
                FileOutputStream fos = new FileOutputStream(tempzip);
                ZipOutputStream zout = new ZipOutputStream(fos);
                try {
                    ZipEntry ze = new ZipEntry(this.name);
                    zout.putNextEntry(ze);
                    MatrixData.copyWithModifications((OutputStream)zout, (InputStream)this.in, this.modifications, (ProgressListener)this.progress);
                    zout.closeEntry();
                    zout.flush();
                }
                catch (IOException e) {
                    ioexception = e;
                    throw ioexception;
                }
                finally {
                    try {
                        zout.close();
                    }
                    catch (IOException e) {
                        if (null == ioexception) {
                            ioexception = e;
                            throw ioexception;
                        }
                        this.logger.error("unable to close ZipOutputStream", (Throwable)e);
                        throw ioexception;
                    }
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
                catch (Throwable t) {
                    try {
                        this.logger.error("copy operation failed", t);
                    }
                    catch (Throwable throwable) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            ioexception = null == ioexception ? e : ioexception;
                            throw ioexception;
                        }
                        throw throwable;
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        ioexception = null == ioexception ? e : ioexception;
                        throw ioexception;
                    }
                }
                this.logger.debug("zip file complete");
                int zipsize = (int)tempzip.length();
                connection.setDoOutput(true);
                connection.setRequestProperty(CONTENT_TYPE_HEADER, CONTENT_TYPE);
                connection.setFixedLengthStreamingMode(zipsize);
                connection.connect();
                this.logger.trace("connection open; starting data send");
                assert (ioexception == null);
                fis = new FileInputStream(tempzip);
                try {
                    OutputStream os = connection.getOutputStream();
                    ByteStreams.copy((InputStream)fis, (OutputStream)os);
                    try {
                        os.close();
                        break block39;
                    }
                    catch (IOException e) {
                        ioexception = null == ioexception ? e : ioexception;
                        throw ioexception;
                    }
                    catch (IOException e) {
                        try {
                            ioexception = e;
                            throw ioexception;
                        }
                        catch (Throwable throwable) {
                            try {
                                os.close();
                            }
                            catch (IOException e2) {
                                ioexception = null == ioexception ? e2 : ioexception;
                                throw ioexception;
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        ioexception = null == ioexception ? e : ioexception;
                        throw ioexception;
                    }
                    throw throwable;
                }
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                ioexception = null == ioexception ? e : ioexception;
                throw ioexception;
            }
        }
        finally {
            this.in.close();
            tempzip.delete();
        }
    }

    @Override
    public void process(HttpURLConnection connection) {
    }
}

