/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.nrg.ecat.EcatSessionVariable;
import org.nrg.ecat.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextEcatVariable
extends EcatSessionVariable
implements DocumentListener {
    private final Logger logger = LoggerFactory.getLogger(TextEcatVariable.class);
    private final JTextField text;

    public TextEcatVariable(Variable variable) {
        super(variable);
        Object v = variable.getValue();
        this.text = new JTextField(null == v ? null : v.toString());
        this.text.getDocument().addDocumentListener(this);
    }

    @Override
    public Component getEditor() {
        return this.text;
    }

    @Override
    public void refresh() {
        this.setDisplayValue(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setDisplayValue(String value) {
        String old = this.text.getText();
        Document d = this.text.getDocument();
        TextEcatVariable textEcatVariable = this;
        synchronized (textEcatVariable) {
            d.removeDocumentListener(this);
            this.logger.trace("Setting text field for " + this.getName() + " = " + value);
            this.text.setText(value);
            d.addDocumentListener(this);
        }
        return old;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.editTo(this.text.getText());
    }
}

