/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;

public class HttpUtils {
    private HttpUtils() {
    }

    public static String readEntity(HttpURLConnection connection) throws IOException {
        InputStream in;
        try {
            in = connection.getInputStream();
            if (null == in) {
                in = connection.getErrorStream();
            }
        }
        catch (IOException e) {
            in = connection.getErrorStream();
        }
        return null == in ? null : HttpUtils.readEntity(in);
    }

    public static StringBuilder readEntity(StringBuilder sb, InputStream in) throws IOException {
        Joiner.on((String)"<p>").appendTo(sb, HttpUtils.readEntityLines(in));
        return sb;
    }

    public static String readEntity(InputStream in) throws IOException {
        return Joiner.on((String)"<p>").join(HttpUtils.readEntityLines(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readEntityLines(HttpURLConnection c) throws IOException {
        List<String> list;
        Object ioexception = null;
        InputStream in = c.getInputStream();
        try {
            list = HttpUtils.readEntityLines(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException e) {
                throw null == ioexception ? e : ioexception;
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw null == ioexception ? e : ioexception;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readEntityLines(InputStream in) throws IOException {
        ArrayList arrayList;
        Object ioexception = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            ArrayList lines = Lists.newArrayList();
            while (null != (line = reader.readLine())) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw null == ioexception ? e : ioexception;
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            throw null == ioexception ? e : ioexception;
        }
        return arrayList;
    }
}

