/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.nrg.io.FileWalkIterator;
import org.nrg.io.Trawler;
import org.nrg.io.dcm.DicomTrawler;
import org.nrg.io.ecat.EcatTrawler;
import org.nrg.upload.data.Session;
import org.nrg.util.ArrayIterator;
import org.nrg.util.EditProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTrawler
implements Callable<List<Session>> {
    private final Logger logger = LoggerFactory.getLogger(MasterTrawler.class);
    private final Trawler[] trawlers = new Trawler[]{new DicomTrawler(), new EcatTrawler()};
    private final Collection<File> roots;
    private final EditProgressMonitor pm;

    public MasterTrawler(EditProgressMonitor monitor, Iterable<File> files) {
        this.pm = monitor;
        this.roots = Lists.newArrayList(files);
    }

    @Override
    public List<Session> call() {
        ArrayList sessions = Lists.newArrayList();
        FileWalkIterator filei = new FileWalkIterator(this.roots, this.pm);
        ArrayIterator<Trawler> trawleri = new ArrayIterator<Trawler>(this.trawlers);
        LinkedHashSet remaining = Sets.newLinkedHashSet();
        sessions.addAll(((Trawler)trawleri.next()).trawl((Iterator<File>)filei, remaining, this.pm));
        while (trawleri.hasNext()) {
            ArrayList files = Lists.newArrayList((Iterable)remaining);
            this.logger.trace("trawling {}", (Object)files);
            remaining.clear();
            sessions.addAll(((Trawler)trawleri.next()).trawl(files.iterator(), remaining, this.pm));
            if (null == this.pm || !this.pm.isCanceled()) continue;
            this.logger.debug("user canceled file search");
            sessions.clear();
            return sessions;
        }
        return sessions;
    }
}

