/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import org.netbeans.spi.wizard.ResultProgressHandle;
import org.nrg.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadStatisticsReporter {
    private static final long SCALE = 1024L;
    private final Logger logger = LoggerFactory.getLogger(UploadStatisticsReporter.class);
    private final ResultProgressHandle progress;
    private long bytesToSend = 0L;
    private long bytesSent = 0L;

    public UploadStatisticsReporter(ResultProgressHandle progress) {
        this.progress = progress;
    }

    private void update() {
        if (this.bytesSent > 0L) {
            if (this.bytesSent > this.bytesToSend) {
                this.logger.error("more bytes sent ({}) than available ({})?", (Object)this.bytesSent, (Object)this.bytesToSend);
                this.progress.setBusy(this.toString());
            } else {
                long kToSend = this.bytesToSend / 1024L;
                if (kToSend > Integer.MAX_VALUE) {
                    this.logger.debug("progress overflow: {} / {}", (Object)(this.bytesSent / 1024L), (Object)kToSend);
                    this.progress.setBusy(this.toString());
                } else {
                    assert (this.bytesSent > 0L);
                    assert (this.bytesSent / 1024L <= kToSend);
                    this.progress.setProgress(this.toString(), (int)(this.bytesSent / 1024L), (int)kToSend);
                }
            }
        } else {
            this.progress.setBusy(this.toString());
        }
    }

    public long addToSend(long size) {
        this.bytesToSend += size;
        this.update();
        return this.bytesToSend;
    }

    public long addSent(long size) {
        this.bytesSent += size;
        this.update();
        return this.bytesSent;
    }

    public String toString() {
        if (this.bytesSent > 0L) {
            StringBuilder sb = new StringBuilder();
            Utils.showNearestUnits(sb, this.bytesSent, "b");
            sb.append("/");
            Utils.showNearestUnits(sb, this.bytesToSend, "b");
            sb.append(" ");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder("Preparing...");
        Utils.showNearestUnits(sb, this.bytesToSend, "b");
        return sb.toString();
    }
}

