/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io.dcm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.Study;
import org.nrg.io.Trawler;
import org.nrg.upload.data.Session;
import org.nrg.util.EditProgressMonitor;
import org.nrg.util.MapRegistry;

public final class DicomTrawler
implements Trawler {
    @Override
    public Collection<Session> trawl(Iterator<File> files, EditProgressMonitor pm) {
        return this.trawl(files, null, pm);
    }

    @Override
    public Collection<Session> trawl(Iterator<File> files, Collection<File> remaining, EditProgressMonitor pm) {
        MapRegistry<Study> studies = new MapRegistry<Study>();
        while (files.hasNext()) {
            DicomObject o;
            if (null != pm && pm.isCanceled()) {
                return new ArrayList<Session>();
            }
            File f = files.next();
            if (!f.isFile()) continue;
            try {
                o = DicomUtils.read((File)f);
            }
            catch (IOException e) {
                remaining.add(f);
                continue;
            }
            catch (Exception e) {
                remaining.add(f);
                continue;
            }
            assert (null != o.getString(524310));
            Study study = studies.get(new Study(o));
            study.getSeries(o, f);
        }
        return new ArrayList<Session>(studies.getAll());
    }
}

