/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io.dcm;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomCodingException;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.nrg.dcm.Series;
import org.nrg.dcm.edit.AttributeException;
import org.nrg.dcm.edit.ScriptApplicator;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.io.HttpUploadException;
import org.nrg.io.HttpUtils;
import org.nrg.io.UploadStatisticsReporter;
import org.nrg.net.RestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSeriesUploader
implements Callable<Set<String>> {
    private static final Set<Integer> successCodes = Sets.newHashSet((Object[])new Integer[]{200, 202});
    private static final int BUF_SIZE = 4096;
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_ZIP = "application/zip";
    private final Logger logger = LoggerFactory.getLogger(ZipSeriesUploader.class);
    private final URL url;
    private final Series series;
    private final Iterable<ScriptApplicator> applicators;
    private final UploadStatisticsReporter progress;
    private final boolean useFixedSizeStreaming;
    private final RestServer xnat;

    public ZipSeriesUploader(URL url, boolean useFixedSizeStreaming, Series series, Iterable<ScriptApplicator> applicators, UploadStatisticsReporter progress, RestServer xnat) {
        this.url = url;
        this.useFixedSizeStreaming = useFixedSizeStreaming;
        this.series = series;
        this.applicators = applicators;
        this.progress = progress;
        this.xnat = xnat;
    }

    @Override
    public Set<String> call() throws AttributeException, HttpUploadException, IOException, ScriptEvaluationException {
        return this.useFixedSizeStreaming ? this.sendFixedSize() : this.sendChunked();
    }

    public Series getSeries() {
        return this.series;
    }

    private String removeCompressionSuffix(String path) {
        return path.replaceAll("\\.[gG][zZ]$", "");
    }

    private int getTopTag() {
        int top = 524312;
        for (ScriptApplicator a : this.applicators) {
            int atop = a.getTopTag();
            if (atop <= top) continue;
            top = atop;
        }
        return top;
    }

    /*
     * Loose catch block
     */
    private void addFileToZip(File f, ZipOutputStream zos, DicomInputHandler handler) throws AttributeException, IOException, ScriptEvaluationException {
        long remainder;
        block33: {
            zos.putNextEntry(new ZipEntry(this.removeCompressionSuffix(f.getPath())));
            IOException ioexception = null;
            FileInputStream fin = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(f.getName().endsWith(".gz") ? new GZIPInputStream(fin) : fin);
            try {
                DicomInputStream dis = new DicomInputStream((InputStream)bis);
                dis.setHandler(handler);
                DicomObject o = dis.readDicomObject();
                for (ScriptApplicator a : this.applicators) {
                    a.apply(f, o);
                }
                DicomOutputStream dos = new DicomOutputStream((OutputStream)zos);
                dos.setAutoFinish(false);
                String tsuid = o.getString(131088, "1.2.840.10008.1.2");
                if (o.contains(131073)) {
                    dos.writeFileMetaInformation(o);
                } else {
                    BasicDicomObject fmi = new BasicDicomObject();
                    fmi.initFileMetaInformation(o.getString(524310), o.getString(524312), tsuid);
                    dos.writeFileMetaInformation((DicomObject)fmi);
                }
                dos.writeDataset(o, tsuid);
                bis.reset();
                remainder = ByteStreams.copy((InputStream)bis, (OutputStream)zos);
                try {
                    dis.close();
                    break block33;
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
                catch (IOException e) {
                    try {
                        ioexception = e;
                        throw ioexception;
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (IOException e2) {
                            ioexception = null == ioexception ? e2 : ioexception;
                            throw ioexception;
                        }
                        throw throwable;
                    }
                }
            }
            catch (DicomCodingException e) {
                this.logger.debug("error reading " + f, (Throwable)e);
                return;
            }
            catch (IOException e) {
                ioexception = null == ioexception ? e : ioexception;
                throw ioexception;
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    if (null == ioexception) {
                        ioexception = e;
                    }
                    this.logger.error("error closing stream buffer", (Throwable)e);
                }
                try {
                    fin.close();
                }
                catch (IOException e) {
                    if (null == ioexception) {
                        ioexception = e;
                    }
                    this.logger.error("error closing input DICOM file", (Throwable)e);
                }
                if (null != ioexception) {
                    throw ioexception;
                }
            }
        }
        zos.closeEntry();
        this.logger.trace("added {}, {} bytes streamed", (Object)f, (Object)remainder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<String> sendFixedSize() throws AttributeException, HttpUploadException, IOException, ScriptEvaluationException {
        StopTagInputHandler stopHandler = new StopTagInputHandler(this.getTopTag() + 1);
        File tempzip = File.createTempFile("scan-upload", ".zip");
        try {
            FileOutputStream fos;
            IOException ioexception;
            block40: {
                this.logger.debug("creating zip file {}", (Object)tempzip);
                ioexception = null;
                fos = new FileOutputStream(tempzip);
                try {
                    ZipOutputStream zos = new ZipOutputStream(fos);
                    this.logger.trace("adding {} files for series {}", (Object)this.series.getFileCount(), (Object)this.series);
                    for (File file : this.series.getFiles()) {
                        this.addFileToZip(file, zos, (DicomInputHandler)stopHandler);
                    }
                    try {
                        zos.close();
                        break block40;
                    }
                    catch (IOException e) {
                        ioexception = null == ioexception ? e : ioexception;
                        throw ioexception;
                    }
                    catch (IOException e) {
                        try {
                            this.logger.trace("I/O exception building zipfile", (Throwable)e);
                            ioexception = e;
                            throw ioexception;
                        }
                        catch (Throwable throwable) {
                            try {
                                zos.close();
                            }
                            catch (IOException e2) {
                                ioexception = null == ioexception ? e2 : ioexception;
                                throw ioexception;
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        ioexception = null == ioexception ? e : ioexception;
                        throw ioexception;
                    }
                    throw throwable;
                }
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                ioexception = null == ioexception ? e : ioexception;
                throw ioexception;
            }
            this.logger.debug("zip file complete");
            long zipsize = tempzip.length();
            this.progress.addToSend(zipsize - this.series.getSize());
            this.logger.trace("creating connection to {}", (Object)this.url);
            HttpURLConnection c = (HttpURLConnection)this.url.openConnection();
            c.setRequestMethod("POST");
            c.setDoOutput(true);
            c.setRequestProperty(CONTENT_TYPE_HEADER, CONTENT_TYPE_ZIP);
            this.xnat.addAuthorization(c);
            c.setFixedLengthStreamingMode((int)zipsize);
            c.connect();
            try {
                FileInputStream fis;
                block41: {
                    this.logger.trace("connection open; starting data send");
                    assert (ioexception == null);
                    fis = new FileInputStream(tempzip);
                    try {
                        int chunk;
                        OutputStream os = c.getOutputStream();
                        byte[] buf = new byte[4096];
                        int total = 0;
                        while ((chunk = fis.read(buf)) != -1) {
                            this.logger.trace("copying {} / {}", (Object)total, (Object)zipsize);
                            this.progress.addSent(chunk);
                            os.write(buf, 0, chunk);
                            total += chunk;
                        }
                        try {
                            os.close();
                            break block41;
                        }
                        catch (IOException e) {
                            ioexception = null == ioexception ? e : ioexception;
                            throw ioexception;
                        }
                        catch (IOException e) {
                            try {
                                ioexception = e;
                                throw ioexception;
                            }
                            catch (Throwable throwable) {
                                try {
                                    os.close();
                                }
                                catch (IOException e3) {
                                    ioexception = null == ioexception ? e3 : ioexception;
                                    throw ioexception;
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            ioexception = null == ioexception ? e : ioexception;
                            throw ioexception;
                        }
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ioexception = null == ioexception ? e : ioexception;
                    throw ioexception;
                }
                if (successCodes.contains(c.getResponseCode())) {
                    this.logger.debug("series upload complete");
                    LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(HttpUtils.readEntityLines(c));
                    return linkedHashSet;
                }
                throw new HttpUploadException(c);
            }
            finally {
                c.disconnect();
            }
        }
        finally {
            tempzip.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> sendChunked() throws AttributeException, HttpUploadException, IOException, ScriptEvaluationException {
        this.logger.warn("XNAT may not support chunked mode! After this fails, set fixed-size-streaming to true.");
        HttpURLConnection c = (HttpURLConnection)this.url.openConnection();
        c.setRequestMethod("POST");
        c.setDoInput(true);
        c.setDoOutput(true);
        c.setRequestProperty(CONTENT_TYPE_HEADER, CONTENT_TYPE_ZIP);
        this.xnat.addAuthorization(c);
        c.setChunkedStreamingMode(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connecting to {}", (Object)this.url);
            this.logger.debug("Request properties:");
            for (Map.Entry<String, List<String>> m : c.getRequestProperties().entrySet()) {
                this.logger.debug("  {}", m);
            }
        }
        c.connect();
        StopTagInputHandler stopHandler = new StopTagInputHandler(this.getTopTag() + 1);
        try {
            this.logger.trace("connection open; starting data send");
            IOException ioexception = null;
            ZipOutputStream zos = new ZipOutputStream(c.getOutputStream());
            try {
                for (File file : this.series.getFiles()) {
                    this.progress.addSent(file.length());
                    this.logger.trace("sending {}", (Object)file);
                    this.addFileToZip(file, zos, (DicomInputHandler)stopHandler);
                }
            }
            catch (IOException e) {
                try {
                    ioexception = e;
                    throw ioexception;
                }
                catch (Throwable throwable) {
                    try {
                        zos.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        IOException iOException;
                        if (null == ioexception) {
                            iOException = e2;
                            throw iOException;
                        }
                        iOException = ioexception;
                        throw iOException;
                    }
                }
            }
            try {
                zos.close();
            }
            catch (IOException e) {
                IOException iOException;
                if (null == ioexception) {
                    iOException = e;
                    throw iOException;
                }
                iOException = ioexception;
                throw iOException;
            }
            if (successCodes.contains(c.getResponseCode())) {
                LinkedHashSet e = Sets.newLinkedHashSet(HttpUtils.readEntityLines(c));
                return e;
            }
            if (!this.logger.isDebugEnabled()) throw new HttpUploadException(c);
            this.logger.debug("Response {} {} headers:", (Object)c.getResponseCode(), (Object)c.getResponseMessage());
            Iterator<Object> i$ = c.getHeaderFields().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                this.logger.debug("  {}", (Object)entry);
            }
            throw new HttpUploadException(c);
        }
        finally {
            c.disconnect();
        }
    }
}

