/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io.ecat;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.nrg.ecat.EcatSession;
import org.nrg.ecat.MatrixDataFile;
import org.nrg.io.Trawler;
import org.nrg.upload.data.Session;
import org.nrg.util.EditProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EcatTrawler
implements Trawler {
    private final Logger logger = LoggerFactory.getLogger(EcatTrawler.class);

    @Override
    public Collection<Session> trawl(Iterator<File> files, EditProgressMonitor pm) {
        return this.trawl(files, null, pm);
    }

    @Override
    public Collection<Session> trawl(Iterator<File> files, Collection<File> remaining, EditProgressMonitor pm) {
        ArrayListMultimap filesets = ArrayListMultimap.create();
        while (files.hasNext()) {
            if (null != pm && pm.isCanceled()) {
                return new ArrayList<Session>();
            }
            File f = files.next();
            this.logger.trace("checking {}", (Object)f);
            try {
                MatrixDataFile mdf = new MatrixDataFile(f);
                filesets.put((Object)mdf.getPatientID(), (Object)mdf);
            }
            catch (IOException e) {
                this.logger.debug(f + " is not an ECAT file", (Throwable)e);
                if (null == remaining) continue;
                remaining.add(f);
            }
        }
        this.logger.trace("found ECAT sessions: {}", (Object)filesets);
        ArrayList sessions = Lists.newArrayList();
        for (String label : Sets.newTreeSet((Iterable)filesets.keySet())) {
            sessions.add(new EcatSession(filesets.get((Object)label)));
        }
        return sessions;
    }
}

