/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.json.JSONObject;
import org.nrg.net.HttpURLConnectionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRequestConnectionProcessor
implements HttpURLConnectionProcessor {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String MEDIA_TYPE = "application/json";
    private final Logger logger = LoggerFactory.getLogger(JSONRequestConnectionProcessor.class);
    private final JSONObject request;
    private final ByteArrayOutputStream response = new ByteArrayOutputStream();

    public JSONRequestConnectionProcessor(JSONObject request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.addRequestProperty(CONTENT_TYPE_HEADER, MEDIA_TYPE);
        connection.connect();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        try {
            this.request.write((Writer)writer);
        }
        catch (Throwable t) {
            System.out.println("failure");
            t.printStackTrace();
            this.logger.debug("stream copy failed", t);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        Object ioexception = null;
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)this.response);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                if (null == ioexception) {
                    throw e;
                }
                this.logger.warn("Ignoring shadowed error closing HTTP response", (Throwable)e);
                throw ioexception;
            }
        }
    }

    public String getResponseEntity() {
        return new String(this.response.toByteArray(), Charset.defaultCharset());
    }
}

