/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.nrg.IOUtils;
import org.nrg.ProgressListener;
import org.nrg.net.HttpURLConnectionProcessor;
import org.nrg.upload.ui.ResultProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringResponseProcessor
implements HttpURLConnectionProcessor {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final int BUF_SIZE = 512;
    private final Logger logger = LoggerFactory.getLogger(StringResponseProcessor.class);
    private final InputStream in;
    private final String mimeMediaType;
    private final Integer contentLength;
    private final ResultProgressListener progress;
    private final StringBuilder sb = new StringBuilder();

    public StringResponseProcessor(InputStream in, String mimeMediaType, Integer contentLength, ResultProgressHandle progress) {
        this.in = in;
        this.mimeMediaType = mimeMediaType;
        this.contentLength = contentLength;
        if (null != contentLength && contentLength < 0) {
            throw new IllegalArgumentException("content length = " + contentLength + "; must be > 0");
        }
        this.progress = null == contentLength ? null : new ResultProgressListener(progress, 0, contentLength);
    }

    public StringResponseProcessor() {
        this(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(HttpURLConnection connection) throws IOException {
        block11: {
            if (null == this.in) {
                return;
            }
            connection.setDoOutput(true);
            if (null != this.mimeMediaType) {
                connection.addRequestProperty(CONTENT_TYPE_HEADER, this.mimeMediaType);
            }
            if (null != this.contentLength) {
                connection.setFixedLengthStreamingMode(this.contentLength);
            }
            connection.connect();
            try {
                OutputStream out = connection.getOutputStream();
                try {
                    IOUtils.copy((OutputStream)out, (InputStream)this.in, (ProgressListener)this.progress);
                    out.flush();
                }
                catch (Throwable t) {
                    try {
                        System.out.println("failure");
                        t.printStackTrace();
                        this.logger.debug("stream copy failed", t);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        out.close();
                    }
                }
                out.close();
            }
            finally {
                this.in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        try {
            byte[] buf = new byte[512];
            int n = in.read(buf);
            while (n > 0) {
                this.sb.append(new String(buf, 0, n));
                n = in.read(buf);
            }
        }
        finally {
            in.close();
        }
    }

    public String toString() {
        return this.sb.toString();
    }
}

