/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net.xnat;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.Callable;
import org.nrg.net.HttpURLConnectionProcessor;
import org.nrg.net.RestServer;

class BaseScriptApplicatorRetreiver<ApplicatorT>
implements Callable<ApplicatorT> {
    private final RestServer xnat;
    private final String path;
    private final ScriptApplicatorFactory<ApplicatorT> factory;

    BaseScriptApplicatorRetreiver(RestServer xnat, ScriptApplicatorFactory<ApplicatorT> factory, String path) {
        this.xnat = xnat;
        this.factory = factory;
        this.path = path;
    }

    @Override
    public final ApplicatorT call() throws Exception {
        ConnectionProcessor<ApplicatorT> processor = new ConnectionProcessor<ApplicatorT>(this.factory);
        this.xnat.doGet(this.path, processor);
        return processor.getApplicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <ApplicatorT> ApplicatorT getApplicator(ScriptApplicatorFactory<ApplicatorT> factory, String resourcePath) throws Exception {
        InputStream in = BaseScriptApplicatorRetreiver.class.getResourceAsStream(resourcePath);
        if (null == in) {
            return null;
        }
        try {
            ApplicatorT ApplicatorT = factory.createScriptApplicator(in);
            return ApplicatorT;
        }
        finally {
            in.close();
        }
    }

    public static final class ConnectionProcessor<ApplicatorT>
    implements HttpURLConnectionProcessor {
        private final ScriptApplicatorFactory<ApplicatorT> factory;
        private ApplicatorT applicator = null;

        public ConnectionProcessor(ScriptApplicatorFactory<ApplicatorT> factory) {
            this.factory = factory;
        }

        @Override
        public void prepare(HttpURLConnection c) {
        }

        @Override
        public void process(HttpURLConnection c) throws Exception {
            this.applicator = this.factory.createScriptApplicator(c.getInputStream());
        }

        public ApplicatorT getApplicator() {
            return this.applicator;
        }
    }

    public static interface ScriptApplicatorFactory<A> {
        public A createScriptApplicator(InputStream var1) throws Exception;
    }
}

