/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net.xnat;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.nrg.dcm.edit.ScriptApplicator;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Variable;
import org.nrg.net.RestServer;
import org.nrg.net.xnat.BaseScriptApplicatorRetreiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DicomScriptApplicatorRetriever
implements Callable<Iterable<ScriptApplicator>> {
    private static final String sitePath = "/data/config/anon/script?contents=true";
    private final Logger logger = LoggerFactory.getLogger(DicomScriptApplicatorRetriever.class);
    private final RestServer xnat;
    private final String project;
    private final String projBasePath;
    private final BaseScriptApplicatorRetreiver.ScriptApplicatorFactory<ScriptApplicator> factory;

    public DicomScriptApplicatorRetriever(RestServer xnat, String project, Map<String, ScriptFunction> scriptFunctions) {
        this.xnat = xnat;
        this.project = project;
        this.projBasePath = "/data/config/edit/projects/" + project + "/image/dicom/";
        this.factory = DicomScriptApplicatorRetriever.buildFactory(scriptFunctions);
    }

    private static BaseScriptApplicatorRetreiver.ScriptApplicatorFactory<ScriptApplicator> buildFactory(final Map<String, ScriptFunction> scriptFunctions) {
        return new BaseScriptApplicatorRetreiver.ScriptApplicatorFactory<ScriptApplicator>(){

            @Override
            public ScriptApplicator createScriptApplicator(InputStream in) throws IOException, ScriptEvaluationException {
                return new ScriptApplicator(in, scriptFunctions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<ScriptApplicator> call() throws Exception {
        ArrayList applicators = Lists.newArrayList();
        BaseScriptApplicatorRetreiver.ConnectionProcessor<ScriptApplicator> textProcessor = new BaseScriptApplicatorRetreiver.ConnectionProcessor<ScriptApplicator>(this.factory);
        this.xnat.doGet(sitePath, textProcessor);
        ScriptApplicator siteScript = textProcessor.getApplicator();
        if (null != siteScript && !siteScript.getStatements().isEmpty()) {
            applicators.add(siteScript);
        }
        Collection<Object> statusc = this.xnat.getValues(this.projBasePath + "status", "edit");
        this.logger.trace("project {} script status: {}", (Object)this.project, statusc);
        if (statusc.contains("true")) {
            Collection<Object> scriptsc = this.xnat.getValues(this.projBasePath + "script", "script");
            this.logger.trace("project {} script text: {}", (Object)this.project, scriptsc);
            for (Object scripto : scriptsc) {
                if (null == scripto) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream(scripto.toString().getBytes("UTF-8"));
                try {
                    ScriptApplicator projScript = this.factory.createScriptApplicator(bais);
                    if (null == projScript || projScript.getStatements().isEmpty()) continue;
                    applicators.add(projScript);
                }
                finally {
                    bais.close();
                }
            }
        }
        for (int i = 1; i < applicators.size(); ++i) {
            List vs = ((ScriptApplicator)applicators.get(i)).getSortedVariables();
            for (int j = 0; j < i; ++j) {
                for (Variable v : vs) {
                    ((ScriptApplicator)applicators.get(j)).unify(v);
                }
            }
        }
        return applicators;
    }
}

