/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net.xnat;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.nrg.net.RestServer;
import org.nrg.net.StringListConnectionProcessor;

public final class PETTracerRetriever
implements Callable<Set<String>> {
    private static final String DEFAULT_TRACERS_RESOURCE = "/PET-tracers.txt";
    private static final Set<String> defaultTracers = PETTracerRetriever.getDefaultTracers("/PET-tracers.txt");
    private final RestServer xnat;
    private final String path;

    public PETTracerRetriever(RestServer xnat, String project) {
        this.xnat = xnat;
        this.path = "/REST/projects/" + project + "/resources/UPLOAD_CONFIG/files/PET-tracers.txt";
    }

    @Override
    public Set<String> call() {
        StringListConnectionProcessor processor = new StringListConnectionProcessor();
        try {
            this.xnat.doGet(this.path, processor);
            return Sets.newLinkedHashSet((Iterable)processor);
        }
        catch (Throwable t) {
            return PETTracerRetriever.getDefaultTracers();
        }
    }

    public static final Set<String> getDefaultTracers() {
        return Sets.newLinkedHashSet(defaultTracers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Set<String> getDefaultTracers(String resource) {
        try {
            LinkedHashSet linkedHashSet;
            InputStream in = PETTracerRetriever.class.getResourceAsStream(resource);
            if (null == in) {
                throw new RuntimeException("Unable to load default PET tracers");
            }
            IOException ioexception = null;
            try {
                linkedHashSet = Sets.newLinkedHashSet(StringListConnectionProcessor.readStrings(in));
            }
            catch (IOException e) {
                try {
                    ioexception = e;
                    throw ioexception;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        IOException iOException;
                        if (null == ioexception) {
                            iOException = e2;
                            throw iOException;
                        }
                        iOException = ioexception;
                        throw iOException;
                    }
                }
            }
            try {
                in.close();
                return linkedHashSet;
            }
            catch (IOException e) {
                IOException iOException;
                if (null == ioexception) {
                    iOException = e;
                    throw iOException;
                }
                iOException = ioexception;
                throw iOException;
            }
        }
        catch (IOException e3) {
            throw new RuntimeException("Unable to read default PET tracers", e3);
        }
    }
}

