/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.nrg.upload.data.AbstractSessionVariable;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.ValueValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumeratedSessionVariable
extends AbstractSessionVariable
implements SessionVariable,
ItemListener {
    private static final String MAKE_SELECTION = "(Select)";
    private static final String OTHER_ITEM = "Other...";
    private static final Collection<?> UNSELECTABLES = Arrays.asList("(Select)", "Other...");
    private final Logger logger = LoggerFactory.getLogger(EnumeratedSessionVariable.class);
    private final JComboBox comboBox = new JComboBox();
    private Object lastDeselected = null;
    private SessionVariable shadowed;
    private Collection<?> items;
    private boolean requireSelection;
    private boolean allowOther;

    private EnumeratedSessionVariable(String name, String exportField, Collection<?> items, SessionVariable shadowed, boolean requireSelection, boolean allowOther) {
        super(name, exportField);
        this.shadowed = shadowed;
        this.requireSelection = requireSelection;
        this.allowOther = allowOther;
        this.setItems(items);
    }

    public EnumeratedSessionVariable(String name, String exportField, Collection<?> items, boolean requireSelection, boolean allowOther) {
        this(name, exportField, items, null, requireSelection, allowOther);
    }

    @Override
    public JComboBox getEditor() {
        return this.comboBox;
    }

    @Override
    public String getValue() {
        Object selectedItem = this.comboBox.getSelectedItem();
        return MAKE_SELECTION == selectedItem ? null : selectedItem.toString();
    }

    @Override
    public String getValueMessage() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (MAKE_SELECTION == selectedItem) {
            return "Select a value for " + this.getName();
        }
        String v = this.comboBox.getSelectedItem().toString();
        if (null == v || "".equals(v)) {
            return "Select a value for " + this.getName();
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (MAKE_SELECTION == this.comboBox.getItemAt(0)) {
            this.comboBox.removeItem(MAKE_SELECTION);
        }
        if (2 == e.getStateChange()) {
            this.lastDeselected = e.getItem();
            if (UNSELECTABLES.contains(this.lastDeselected)) {
                this.lastDeselected = null;
            }
        } else if (1 == e.getStateChange() && OTHER_ITEM == e.getItem()) {
            String val = JOptionPane.showInputDialog("Enter a value for " + this.getName() + ":");
            if (null == val) {
                if (null == this.lastDeselected) {
                    this.comboBox.setSelectedIndex(0);
                } else {
                    this.comboBox.setSelectedItem(this.lastDeselected);
                }
            } else {
                if (null == this.findItem(this.comboBox, val)) {
                    this.comboBox.removeItem(OTHER_ITEM);
                    this.comboBox.addItem(val);
                    this.comboBox.addItem(OTHER_ITEM);
                }
                this.comboBox.setSelectedItem(val);
            }
        }
        this.fireHasChanged();
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setValue(String value) {
        Object old = this.comboBox.getSelectedItem();
        EnumeratedSessionVariable enumeratedSessionVariable = this;
        synchronized (enumeratedSessionVariable) {
            if (null == this.findItem(this.comboBox, value)) {
                this.comboBox.addItem(value);
            }
            this.comboBox.setSelectedItem(value);
        }
        try {
            this.shadowed.setValue(value);
        }
        catch (SessionVariable.InvalidValueException ignore) {
            this.logger.error("new value failed validation on shadowed variable " + this.shadowed, (Throwable)ignore);
        }
        this.fireHasChanged();
        return null == old ? null : old.toString();
    }

    public void setItems(Collection<?> items) {
        if (this.items == null || !this.items.containsAll(items) || !items.containsAll(this.items)) {
            this.items = items;
            String initial = null == this.shadowed ? null : this.shadowed.getValue();
            ArrayList startItems = Lists.newArrayList();
            if (this.requireSelection) {
                startItems.add(MAKE_SELECTION);
                this.addValidator(new ValueValidator(){

                    @Override
                    public boolean isValid(Object value) {
                        EnumeratedSessionVariable.this.logger.trace("checking {} for validity", value);
                        return null != value;
                    }

                    @Override
                    public String getMessage(Object value) {
                        return null == value ? "Select a value for " + EnumeratedSessionVariable.this.getName() : null;
                    }
                });
            }
            startItems.addAll(items);
            if (this.allowOther) {
                startItems.add(OTHER_ITEM);
            }
            this.comboBox.removeItemListener(this);
            this.comboBox.removeAllItems();
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(startItems.toArray()));
            this.comboBox.setEditable(false);
            this.comboBox.addItemListener(this);
            if (!Strings.isNullOrEmpty((String)initial)) {
                this.setValue(initial);
            }
        }
    }

    private Object findItem(JComboBox cb, Object o) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).equals(o)) continue;
            return cb.getItemAt(i);
        }
        return null;
    }
}

