/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.nrg.upload.data.AbstractSessionVariable;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.ValueValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedDependentSessionVariable
extends AbstractSessionVariable
implements SessionVariable,
DocumentListener {
    private final Logger logger = LoggerFactory.getLogger(IndexedDependentSessionVariable.class);
    private final String format;
    private SessionVariable dependency;
    private final ValueValidator validator;
    private final JTextField text;
    private String message = null;
    private boolean edited = false;

    public IndexedDependentSessionVariable(String name, SessionVariable dependency, String format) {
        this(name, dependency, format, new ValueValidator(){

            @Override
            public String getMessage(Object value) {
                return null;
            }

            @Override
            public boolean isValid(Object value) {
                return true;
            }
        });
    }

    public IndexedDependentSessionVariable(String name, SessionVariable dependency, String format, ValueValidator validator) {
        super(name);
        this.format = format;
        this.validator = validator;
        this.setDependency(dependency);
        this.text = new JTextField(this.evaluate());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.edit();
    }

    @Override
    public Component getEditor() {
        return this.text;
    }

    @Override
    public synchronized String getValue() {
        return this.text.getText();
    }

    @Override
    public String getValueMessage() {
        return this.message;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.edit();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void refresh() {
        try {
            if (!this.edited) {
                this.setValue(this.evaluate());
            } else {
                this.validate(this.text.getText());
            }
            this.fireHasChanged();
        }
        catch (SessionVariable.InvalidValueException e) {
            this.logger.trace("ignoring change to " + this.dependency.getName(), (Throwable)e);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.edit();
    }

    @Override
    public synchronized String setValue(String value) throws SessionVariable.InvalidValueException {
        this.message = this.validate(value);
        String old = this.text.getText();
        Document d = this.text.getDocument();
        d.removeDocumentListener(this);
        this.text.setText(value);
        d.addDocumentListener(this);
        return old;
    }

    public SessionVariable getDependency() {
        return this.dependency;
    }

    public void setDependency(SessionVariable dependency) {
        this.dependency = dependency;
    }

    private void edit() {
        this.edited = true;
        try {
            this.validate(this.text.getText());
            this.fireHasChanged();
        }
        catch (SessionVariable.InvalidValueException e) {
            this.fireIsInvalid(this.text.getText(), e.getMessage());
        }
    }

    private String evaluate() {
        String value;
        String name;
        int i = 1;
        do {
            value = null;
            if (this.getDependency() == null) continue;
            value = this.getDependency().getValue();
        } while (!this.validator.isValid(name = String.format(this.format, value, i++)));
        return name;
    }
}

