/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import org.nrg.upload.data.ValueValidator;
import org.nrg.xnat.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelValueValidator
implements ValueValidator {
    private static final LabelValueValidator instance = new LabelValueValidator();
    private final Logger logger = LoggerFactory.getLogger(LabelValueValidator.class);

    private LabelValueValidator() {
    }

    public static LabelValueValidator getInstance() {
        return instance;
    }

    @Override
    public String getMessage(Object value) {
        if (this.isValid(value)) {
            return null;
        }
        if (null == value || "".equals(value)) {
            return "Empty label not allowed.";
        }
        return "Only numbers, letters, or _ allowed in label.";
    }

    @Override
    public boolean isValid(Object value) {
        this.logger.trace("Checking {} for validity", value);
        return null != value && Labels.isValidLabel((CharSequence)value.toString());
    }
}

