/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.nrg.upload.data.AbstractSessionVariable;
import org.nrg.upload.data.SessionVariable;

public class MutableSessionVariable
extends AbstractSessionVariable
implements DocumentListener {
    private final JTextField editor;
    private String value;
    private String message = null;

    public MutableSessionVariable(String name, String value) {
        super(name);
        this.value = value;
        this.editor = new JTextField(value);
        this.editor.getDocument().addDocumentListener(this);
    }

    @Override
    public final void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public final JTextField getEditor() {
        return this.editor;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final String getValueMessage() {
        return this.message;
    }

    @Override
    public final void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public final boolean isHidden() {
        return false;
    }

    @Override
    public final void refresh() {
    }

    @Override
    public final void removeUpdate(DocumentEvent e) {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String setValue(String v) throws SessionVariable.InvalidValueException {
        this.message = this.validate(v);
        String old = this.value;
        Document d = this.editor.getDocument();
        MutableSessionVariable mutableSessionVariable = this;
        synchronized (mutableSessionVariable) {
            d.removeDocumentListener(this);
            this.value = v;
            this.editor.setText(this.value);
            d.addDocumentListener(this);
        }
        return old;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" ").append(this.getName()).append(" = ").append(this.value);
        return sb.toString();
    }

    private final void update() {
        String v = this.editor.getText();
        try {
            this.message = this.validate(v);
            this.value = v;
            this.fireHasChanged();
        }
        catch (SessionVariable.InvalidValueException e) {
            this.fireIsInvalid(v, e.getMessage());
        }
    }
}

