/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.nrg.ecat.FormatSessionDateFunction;
import org.nrg.ecat.IndexedSessionLabelFunction;
import org.nrg.ecat.edit.ScriptApplicator;
import org.nrg.ecat.edit.ScriptFunction;
import org.nrg.framework.constants.PrearchiveCode;
import org.nrg.net.RestServer;
import org.nrg.net.xnat.DicomScriptApplicatorRetriever;
import org.nrg.net.xnat.ECATScriptApplicatorRetriever;
import org.nrg.net.xnat.PETTracerRetriever;
import org.nrg.net.xnat.ProjectPreArcCodeRetriever;
import org.nrg.net.xnat.ProjectSessionLister;
import org.nrg.net.xnat.ProjectSubjectLister;
import org.nrg.upload.data.Session;
import org.nrg.upload.data.Subject;

public class Project {
    public static final String AUTO_ARCHIVE = "autoArchive";
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final String name;
    private final RestServer xnat;
    private final Future<Map<String, String>> subjects;
    private final Set<Subject> newSubjects = Sets.newLinkedHashSet();
    private final Future<Map<String, String>> sessions;
    private final Future<Iterable<org.nrg.dcm.edit.ScriptApplicator>> dicomScriptApplicator;
    private final Future<ScriptApplicator> ecatScriptApplicator;
    private final Future<Set<String>> petTracers;
    private final Future<PrearchiveCode> prearchiveCode;

    public Project(String name, RestServer xnat, Map<?, ?> wizardParams) {
        this.name = name;
        this.xnat = xnat;
        this.sessions = this.executor.submit(new ProjectSessionLister(xnat, name));
        this.subjects = this.executor.submit(new ProjectSubjectLister(xnat, name));
        this.dicomScriptApplicator = this.executor.submit(new DicomScriptApplicatorRetriever(xnat, name, Project.getDicomFunctions(this.sessions)));
        this.ecatScriptApplicator = this.executor.submit(new ECATScriptApplicatorRetriever(xnat, name, Project.getEcatFunctions(this.sessions, wizardParams)));
        this.petTracers = this.executor.submit(new PETTracerRetriever(xnat, name));
        this.prearchiveCode = this.executor.submit(new ProjectPreArcCodeRetriever(xnat, name));
    }

    public void addSubject(Subject subject) {
        this.newSubjects.add(subject);
    }

    private static Map<String, org.nrg.dcm.edit.ScriptFunction> getDicomFunctions(Future<Map<String, String>> sessions) {
        return Collections.singletonMap("makeSessionLabel", new org.nrg.dcm.IndexedSessionLabelFunction(sessions));
    }

    private static Map<String, ? extends ScriptFunction> getEcatFunctions(Future<Map<String, String>> sessions, final Map<?, ?> wizardParams) {
        HashMap m = Maps.newHashMap();
        m.put("makeSessionLabel", new IndexedSessionLabelFunction(sessions));
        m.put("formatSessionDate", new FormatSessionDateFunction(new Callable<Session>(){

            @Override
            public Session call() throws Exception {
                return (Session)wizardParams.get("*session*");
            }
        }));
        return m;
    }

    public RestServer getRestServer() {
        return this.xnat;
    }

    public Collection<Subject> getSubjects() throws ExecutionException, InterruptedException {
        LinkedHashSet s = Sets.newLinkedHashSet();
        for (Map.Entry<String, String> me : this.subjects.get().entrySet()) {
            s.add(new Subject(me.getKey(), me.getValue()));
        }
        s.addAll(this.newSubjects);
        return s;
    }

    public boolean hasSubject(String name) throws ExecutionException, InterruptedException {
        for (Subject subject : this.getSubjects()) {
            if (!name.equals(subject.getLabel())) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getSessionLabels() throws InterruptedException, ExecutionException {
        return this.sessions.get();
    }

    public Iterable<org.nrg.dcm.edit.ScriptApplicator> getDicomScriptApplicators() throws InterruptedException, ExecutionException {
        return this.dicomScriptApplicator.get();
    }

    public ScriptApplicator getEcatScriptApplicator() throws InterruptedException, ExecutionException {
        return this.ecatScriptApplicator.get();
    }

    public Set<String> getPETTracers() throws InterruptedException, ExecutionException {
        return this.petTracers.get();
    }

    public PrearchiveCode getPrearchiveCode() throws InterruptedException, ExecutionException {
        return this.prearchiveCode.get();
    }

    public void dispose() {
        this.sessions.cancel(true);
        this.subjects.cancel(true);
        this.dicomScriptApplicator.cancel(true);
        this.ecatScriptApplicator.cancel(true);
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public String toString() {
        return this.name;
    }
}

