/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import java.awt.Component;
import org.nrg.upload.data.ValueListener;
import org.nrg.upload.data.ValueValidator;

public interface SessionVariable {
    public void addListener(ValueListener var1);

    public void addValidator(ValueValidator var1);

    public String getDescription();

    public String getExportField();

    public Component getEditor();

    public String getName();

    public String getValue();

    public String getValueMessage();

    public boolean isMutable();

    public boolean isHidden();

    public void refresh();

    public void removeListener(ValueListener var1);

    public String setDescription(String var1);

    public SessionVariable fixValue();

    public SessionVariable fixValue(String var1) throws InvalidValueException;

    public String setValue(String var1) throws InvalidValueException;

    public String validate(String var1) throws InvalidValueException;

    public static class InvalidValueException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidValueException(String message) {
            super(message);
        }

        public InvalidValueException(SessionVariable variable, String value) {
            this(InvalidValueException.buildMessage(variable, value));
        }

        public InvalidValueException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidValueException(SessionVariable variable, String value, Throwable cause) {
            this(InvalidValueException.buildMessage(variable, value), cause);
        }

        private static String buildMessage(SessionVariable variable, String value) {
            StringBuilder sb = new StringBuilder("Invalid value for ");
            sb.append(variable.getName()).append(": ");
            sb.append(value);
            return sb.toString();
        }
    }
}

