/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.nrg.net.RestServer;
import org.nrg.net.StringResponseProcessor;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Subject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubjectInformation {
    private static final String MIME_TYPE = "text/xml";
    private final RestServer xnat;
    private final Project project;
    private final String uri;
    private String label;

    public SubjectInformation(RestServer xnat, Project project) {
        this.xnat = xnat;
        this.project = project;
        StringBuilder sb = new StringBuilder("/REST/projects/");
        sb.append(project.toString());
        sb.append("/subjects");
        this.uri = sb.toString();
    }

    public Subject uploadTo() throws UploadSubjectException {
        StringResponseProcessor processor = this.createProcessor();
        try {
            this.xnat.doPost(this.uri, processor);
        }
        catch (Exception e) {
            throw new UploadSubjectException("Error submitting new subject XML to XNAT.", e);
        }
        return new Subject(this.label, this.parseId(processor.toString()));
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    protected Document buildXML() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.getDOMImplementation().createDocument("http://nrg.wustl.edu/xnat", "xnat:Subject", null);
        Element root = document.getDocumentElement();
        root.setAttribute("project", this.project.toString());
        root.setAttribute("label", this.label);
        return document;
    }

    private StringResponseProcessor createProcessor() throws UploadSubjectException {
        try {
            InputStream xmlStream = this.transformXML(this.buildXML());
            StringResponseProcessor processor = new StringResponseProcessor(xmlStream, MIME_TYPE, null, null);
            return processor;
        }
        catch (Exception e) {
            throw new UploadSubjectException("Error generating XML to create new subject.", e);
        }
    }

    private InputStream transformXML(Document document) throws TransformerConfigurationException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(source, result);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private String parseId(String response) {
        String[] parts = response.trim().split("/");
        return parts[parts.length - 1];
    }

    public static final class UploadSubjectException
    extends Exception {
        private static final long serialVersionUID = -1331357997499624104L;

        public UploadSubjectException(String message, Throwable e) {
            super(message, e);
        }
    }
}

