/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.nrg.dcm.DicomSessionVariable;
import org.nrg.dcm.SOPModel;
import org.nrg.dcm.SessionVariableValue;
import org.nrg.ecat.EcatSessionVariable;
import org.nrg.ecat.edit.ConstantValue;
import org.nrg.ecat.edit.MultipleInitializationException;
import org.nrg.ecat.edit.Value;
import org.nrg.framework.constants.AutoArchive;
import org.nrg.framework.constants.PrearchiveCode;
import org.nrg.net.xnat.PETTracerRetriever;
import org.nrg.upload.data.AssignedSessionVariable;
import org.nrg.upload.data.EnumeratedSessionVariable;
import org.nrg.upload.data.ExcludingValueValidator;
import org.nrg.upload.data.IndexedDependentSessionVariable;
import org.nrg.upload.data.LabelValueValidator;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Session;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.SessionVariableConsumer;
import org.nrg.upload.data.Subject;
import org.nrg.upload.ui.VariableAssignmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssignSessionVariablesPage
extends WizardPage
implements SessionVariableConsumer,
PropertyChangeListener {
    private static final long serialVersionUID = -2786166512597463435L;
    public static final String PRODUCT_NAME = "*session-variables*";
    private static final String STEP_DESCRIPTION = "Enter session details";
    private static final String LONG_DESCRIPTION = "Review session information and enter session details if applicable";
    private static final String DUP_SESSION_ID_TITLE = "Session ID Already Exists";
    private static final String DUP_SESSION_ID_MESSAGE_WITH_OVERWRITE = "<html><p>The session ID you've specified is already present in your project.</p><p>Would you like to overwrite the existing session, append to the existing</p><p>session, or provide a new session ID?</p></html>";
    private static final String[] DUP_SESSION_ID_OPTIONS_WITH_OVERWRITE = new String[]{"Overwrite existing", "Append to existing", "Provide new session ID"};
    private static final String DUP_SESSION_ID_MESSAGE = "<html><p>The session ID you've specified is already present in your project.</p><p>Would you like to append to the existing session, or provide a</p>new session ID?</p></html>";
    private static final String[] DUP_SESSION_ID_OPTIONS = new String[]{"Append to existing", "Provide new session ID"};
    private static final String NULL_SESSION_DATE_TITLE = "Session Has No Associated Date";
    private static final String NULL_SESSION_DATE_MESSAGE = "<html><p>The session you selected has no date associated with it, but you specified a date<p>for the session. This can happen when data has been anonymized or when scan data has been<p>corrupted. Please verify that you've selected the correct session for upload. If not,<p>click the <b>Prev</b> button to return to the previous screen to select a different<p>session or click <b>Next</b> or <b>Finish</b> to continue with the existing session.</p></html>";
    private static final String INVALID_SESSION_DATE_TITLE = "Invalid Session Date/Time";
    private static final String INVALID_SESSION_DATE_MESSAGE = "<html><p>The date and/or time you indicated for your scan session does</p><p>not match the date of the selected session. Please re-check</p><p>the date for your new session and start over or click <b>Prev</b></p><p>and select another session that matches the indicated date.</p></html>";
    private static final String UNEXPECTED_MODALITY_TITLE = "Unexpected Modality";
    private static final String UNEXPECTED_MODALITY_MESSAGE = "<html><p>The expected modality does not match that of the session.</p><p>Please re-check the modality of your new session and start</p><p>over or click <b>Prev</b> and select another session that matches</p><p>the indicated modality.</p></html>";
    private final Logger logger = LoggerFactory.getLogger(AssignSessionVariablesPage.class);
    private final Set<SessionVariable> invalid = Sets.newLinkedHashSet();
    private Project project;
    private Subject subject;
    private Session session;
    private Date sessionDate;
    private SessionVariable sessionLabel;
    private Date confirmedDate;
    private boolean isAutoArchiving = false;
    private boolean warnOnDupeSessionLabels = true;
    private boolean allowOverwriteOnDupeSessionLabels = false;
    private SessionVariable tracer = null;
    private static final GridBagConstraints SPANNING = new GridBagConstraints(){
        private static final long serialVersionUID = 5114328188210435952L;
        {
            this.gridx = 0;
            this.gridwidth = 2;
            this.insets = new Insets(8, 0, 0, 0);
        }
    };
    private static final DateFormat FORMATTER = new SimpleDateFormat("M/d/yyyy HH:mm");

    private boolean isSessionDateOk(Date d1, Date session, TimeZone sessionTimeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d1);
        int hour = cal.get(11);
        int minute = cal.get(12);
        if (hour == 0 && minute == 0) {
            return DateUtils.isSameDay((Date)d1, (Date)session);
        }
        if (sessionTimeZone != null) {
            Calendar sessionCal = Calendar.getInstance();
            sessionCal.setTimeZone(sessionTimeZone);
            sessionCal.setTime(session);
            int sessionHour = sessionCal.get(11);
            return Math.abs(d1.getTime() - session.getTime()) < 86400000L && Math.abs(hour - sessionHour) < 2;
        }
        return Math.abs(d1.getTime() - session.getTime()) < 3660000L;
    }

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public AssignSessionVariablesPage() {
        this.setLayout(new BorderLayout());
        this.setLongDescription(LONG_DESCRIPTION);
    }

    @Override
    public void update(SessionVariable v, boolean isValidValue) {
        this.logger.trace("{} updated to {}", (Object)v, (Object)(isValidValue ? "valid" : "invalid"));
        if (isValidValue) {
            this.invalid.remove(v);
        } else {
            this.invalid.add(v);
            this.setProblem(v.getValueMessage());
        }
        this.setProblem(this.validateContents(null, null));
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        return this.isOkToProceed() ? WizardPanelNavResult.PROCEED : WizardPanelNavResult.REMAIN_ON_PAGE;
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        return this.isOkToProceed() ? WizardPanelNavResult.PROCEED : WizardPanelNavResult.REMAIN_ON_PAGE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.userInputReceived((Component)((Object)this), event);
    }

    protected void recycle() {
        this.removeAll();
    }

    protected void renderingPage() {
        this.initialize();
        String expectedModality = (String)this.getWizardData("*expected-modality*");
        Set<String> modalities = this.session.getModalities();
        if (expectedModality != null && modalities != null) {
            if ("PT".equalsIgnoreCase(expectedModality) || "PET".equalsIgnoreCase(expectedModality)) {
                if (!modalities.contains("PT") && !modalities.contains("PET")) {
                    JOptionPane.showMessageDialog((Component)((Object)this), UNEXPECTED_MODALITY_MESSAGE, UNEXPECTED_MODALITY_TITLE, 2);
                }
            } else if (!modalities.contains(expectedModality)) {
                JOptionPane.showMessageDialog((Component)((Object)this), UNEXPECTED_MODALITY_MESSAGE, UNEXPECTED_MODALITY_TITLE, 2);
            }
        }
        if (this.sessionDate == null && this.confirmedDate != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), NULL_SESSION_DATE_MESSAGE, NULL_SESSION_DATE_TITLE, 2);
        } else if (!this.isSessionDateOk(this.confirmedDate, this.sessionDate, this.session.getTimeZone())) {
            JOptionPane.showMessageDialog((Component)((Object)this), INVALID_SESSION_DATE_MESSAGE, INVALID_SESSION_DATE_TITLE, 0);
        } else {
            this.add(this.addContent(new JPanel(new GridBagLayout())), "Center");
        }
    }

    protected String validateContents(Component component, Object event) {
        String candidate;
        boolean stopForDuplicateSessionId;
        if (!this.isSessionDateOk(this.confirmedDate, this.sessionDate, this.session.getTimeZone())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.confirmedDate);
            return "Click the Previous button and select a session with scan date of " + FORMATTER.format(calendar.getTime());
        }
        if (component != null && component instanceof JTextField && (stopForDuplicateSessionId = this.stopForDuplicateSessionId(candidate = this.sessionLabel != null ? this.sessionLabel.getValue() : ((JTextField)component).getText(), false))) {
            return "You must either select another session, change the session ID, or indicate how you want to handle the duplicate session ID for your auto-archiving project.";
        }
        TreeSet names = Sets.newTreeSet();
        for (SessionVariable v : this.invalid) {
            names.add(v.getName());
        }
        if (names.size() > 0) {
            StringBuilder buffer = new StringBuilder("Some fields have invalid values: ");
            Joiner joiner = Joiner.on((String)", ");
            return joiner.appendTo(buffer, (Iterable)names).toString();
        }
        return null;
    }

    private void initialize() {
        Object candidate;
        this.project = (Project)this.getWizardData("project");
        this.subject = (Subject)this.getWizardData("subject");
        this.session = (Session)this.getWizardData("*session*");
        this.sessionDate = this.session.getDateTime();
        this.sessionLabel = (SessionVariable)this.getWizardData("session");
        if (this.getWizardDataMap().containsKey("warn-on-dupe-session-labels")) {
            this.warnOnDupeSessionLabels = Boolean.parseBoolean(this.getWizardData("warn-on-dupe-session-labels").toString());
        }
        if (this.getWizardDataMap().containsKey("allow-overwrite-on-dupe-session-labels")) {
            this.allowOverwriteOnDupeSessionLabels = Boolean.parseBoolean(this.getWizardData("allow-overwrite-on-dupe-session-labels").toString());
        }
        if ((candidate = this.getWizardData("*session-date*")) != null) {
            if (candidate instanceof Date) {
                this.confirmedDate = (Date)candidate;
            } else if (candidate instanceof String && "no_session_date".equals(candidate)) {
                if (this.sessionDate == null) {
                    this.sessionDate = new Date();
                }
                this.confirmedDate = this.sessionDate;
            }
        }
    }

    private JPanel addContent(JPanel panel) {
        IndexedDependentSessionVariable defaultSessionLabel;
        boolean hasPET;
        this.logger.trace("adding content");
        try {
            this.isAutoArchiving = this.project.getPrearchiveCode() != PrearchiveCode.Manual;
        }
        catch (Exception exception) {
            this.logger.warn("Error when retrieving project prearchive code", (Throwable)exception);
        }
        LinkedHashMap predefs = Maps.newLinkedHashMap();
        predefs.put("project", new AssignedSessionVariable("project", this.project.toString()).fixValue());
        predefs.put("subject", new AssignedSessionVariable("subject", this.subject.toString()).fixValue());
        SessionVariable vSession = (SessionVariable)this.getWizardData("predef-session");
        if (null != vSession) {
            predefs.put("session", vSession);
        }
        LinkedList vars = Lists.newLinkedList(this.session.getVariables(this.getWizardDataMap()));
        this.putWizardData(PRODUCT_NAME, vars);
        this.logger.trace("initialized session variables: {}", (Object)vars);
        Set<String> modalities = this.session.getModalities();
        String leadModality = modalities.contains("PET") ? "PET" : SOPModel.getLeadModality(modalities);
        SessionVariable modalityLabel = null;
        ListIterator i = vars.listIterator();
        while (i.hasNext()) {
            SessionVariable v = (SessionVariable)i.next();
            String name = v.getName();
            if ("session".equals(name)) {
                vSession = v;
            }
            if (predefs.containsKey(name)) {
                SessionVariable predef = (SessionVariable)predefs.get(name);
                this.logger.trace("found predefined variable {} in script", (Object)v);
                i.remove();
                try {
                    v.fixValue(predef.getValue());
                }
                catch (SessionVariable.InvalidValueException e) {
                    throw new RuntimeException(e);
                }
                predefs.put(v.getName(), v);
                continue;
            }
            if ("modalityLabel".equals(name)) {
                modalityLabel = v;
                continue;
            }
            if (!"tracer".equals(name)) continue;
            this.logger.trace("found session variable {}, will shadow", (Object)v);
            String field = v.getExportField();
            if (!Strings.isNullOrEmpty((String)field) && !"xnat:petSessionData/tracer/name".equals(field)) {
                this.logger.error("script variable {} has unexpected export path {}, replacing with tracer", (Object)v, (Object)field);
            }
            i.remove();
            this.tracer = v;
        }
        this.logger.trace("checking for PET in modalities {}", modalities);
        boolean bl = hasPET = modalities.contains("PET") || modalities.contains("PT");
        if (hasPET) {
            LinkedHashSet tracers = Sets.newLinkedHashSet();
            try {
                tracers.addAll(this.project.getPETTracers());
            }
            catch (Throwable t) {
                this.logger.error("error retrieving PET tracers", t);
                tracers.clear();
                tracers.addAll(PETTracerRetriever.getDefaultTracers());
            }
            if (this.tracer == null) {
                this.tracer = new EnumeratedSessionVariable("tracer", "xnat:petSessionData/tracer/name", tracers, true, true);
            } else {
                ((EnumeratedSessionVariable)this.tracer).setItems(tracers);
            }
        }
        if (null != modalityLabel) {
            if (modalityLabel instanceof DicomSessionVariable) {
                DicomSessionVariable dsv = (DicomSessionVariable)modalityLabel;
                try {
                    if (null == this.tracer) {
                        this.logger.trace("setting (hidden) modality label from lead modality {}", (Object)leadModality);
                        dsv.setInitialValue((org.nrg.dcm.edit.Value)new org.nrg.dcm.edit.ConstantValue(leadModality));
                    } else {
                        this.logger.trace("setting (hidden) modality label from tracer variable {}", (Object)this.tracer);
                        dsv.setInitialValue(new SessionVariableValue(this.tracer));
                        this.tracer.addListener(dsv);
                    }
                    dsv.setIsHidden(true);
                }
                catch (org.nrg.dcm.edit.MultipleInitializationException exception) {
                    this.logger.debug("Got MultipleInitializationException", (Throwable)exception);
                }
            } else if (modalityLabel instanceof EcatSessionVariable) {
                EcatSessionVariable esv = (EcatSessionVariable)modalityLabel;
                try {
                    if (null == this.tracer) {
                        esv.setInitialValue((Value)new ConstantValue((Object)leadModality));
                    } else {
                        esv.setInitialValue(new org.nrg.ecat.SessionVariableValue(this.tracer));
                    }
                    esv.setIsHidden(true);
                }
                catch (MultipleInitializationException exception) {
                    this.logger.debug("Got MultipleInitializationException", (Throwable)exception);
                }
            }
        }
        ExcludingValueValidator excludeExistingSessions = this.getSessionExcluder(this.project, true);
        this.logger.trace("starting upload for {}", (Object)predefs);
        if (hasPET) {
            assert (null != this.tracer);
            this.logger.trace("building indexed tracer default session label from {}", (Object)this.tracer);
            defaultSessionLabel = new IndexedDependentSessionVariable("session", this.tracer, this.subject + "_%s%d", excludeExistingSessions);
        } else {
            this.logger.trace("building indexed modality default session label from {}", (Object)leadModality);
            defaultSessionLabel = new IndexedDependentSessionVariable("session", (SessionVariable)predefs.get("subject"), "%s_" + leadModality + "%d", excludeExistingSessions);
        }
        if (null == vSession) {
            vSession = defaultSessionLabel;
            vars.addFirst(vSession);
        } else if (vSession.isMutable() && !LabelValueValidator.getInstance().isValid(vSession.getValue())) {
            SessionVariable scriptSession = vSession;
            try {
                vSession.setValue(defaultSessionLabel.getValue());
            }
            catch (SessionVariable.InvalidValueException e) {
                this.logger.error("unable to set shadowed session variable", (Throwable)e);
            }
            defaultSessionLabel.addShadow(vSession);
            vSession = defaultSessionLabel;
            ListIterator<SessionVariable> li = vars.listIterator();
            while (li.hasNext()) {
                if (scriptSession != li.next()) continue;
                li.set(vSession);
                break;
            }
        }
        if (vSession.isMutable()) {
            IndexedDependentSessionVariable indexed;
            if (this.tracer != null && vSession instanceof IndexedDependentSessionVariable && ((indexed = (IndexedDependentSessionVariable)vSession).getDependency() == null || !indexed.getDependency().equals(this.tracer))) {
                indexed.setDependency(this.tracer);
            }
            vSession.addValidator(LabelValueValidator.getInstance());
        }
        if (hasPET) {
            assert (null != this.tracer);
            if (!vars.contains(this.tracer)) {
                vars.addFirst(this.tracer);
            }
        }
        this.putWizardData(vSession.getName(), vSession);
        this.addSessionIdentifiers(panel, predefs, vars);
        return panel;
    }

    private boolean stopForDuplicateSessionId(String candidate, boolean showDialog) {
        block15: {
            if (this.warnOnDupeSessionLabels || this.isAutoArchiving) {
                try {
                    Map<String, String> labels = this.project.getSessionLabels();
                    if (StringUtils.isBlank((String)candidate) || !labels.containsKey(candidate)) break block15;
                    if (showDialog) {
                        if (this.allowOverwriteOnDupeSessionLabels) {
                            int selected = JOptionPane.showOptionDialog((Component)((Object)this), DUP_SESSION_ID_MESSAGE_WITH_OVERWRITE, DUP_SESSION_ID_TITLE, 1, 3, null, DUP_SESSION_ID_OPTIONS_WITH_OVERWRITE, DUP_SESSION_ID_OPTIONS_WITH_OVERWRITE[2]);
                            switch (selected) {
                                case 0: {
                                    this.putWizardData("autoArchive", AutoArchive.Overwrite);
                                    break;
                                }
                                case 1: {
                                    this.putWizardData("autoArchive", AutoArchive.Append);
                                    break;
                                }
                                case -1: 
                                case 2: {
                                    return true;
                                }
                            }
                        } else {
                            int selected = JOptionPane.showOptionDialog((Component)((Object)this), DUP_SESSION_ID_MESSAGE, DUP_SESSION_ID_TITLE, 0, 3, null, DUP_SESSION_ID_OPTIONS, DUP_SESSION_ID_OPTIONS[1]);
                            switch (selected) {
                                case 0: {
                                    this.putWizardData("autoArchive", AutoArchive.Append);
                                    break;
                                }
                                case -1: 
                                case 1: {
                                    return true;
                                }
                            }
                        }
                        break block15;
                    }
                    return true;
                }
                catch (Exception exception) {
                    this.logger.warn("Error when retrieving project session labels for project", (Throwable)exception);
                }
            }
        }
        return false;
    }

    private void addSessionIdentifiers(JPanel panel, Map<String, SessionVariable> predefs, LinkedList<SessionVariable> vars) {
        for (SessionVariable v : predefs.values()) {
            panel.add((Component)new JLabel(v.getDescription()), VariableAssignmentManager.labelConstraint);
            panel.add((Component)new JLabel(v.getValue()), VariableAssignmentManager.valueConstraint);
        }
        if (vars.size() > 0) {
            panel.add((Component)new JLabel("<html><b>Set session identifiers:</b></html>"), SPANNING);
            panel.add((Component)new JLabel(), VariableAssignmentManager.messageConstraint);
        }
        new VariableAssignmentManager(panel, vars, this);
    }

    private ExcludingValueValidator getSessionExcluder(Project project, boolean isStrict) {
        Set<String> labels;
        try {
            labels = project.getSessionLabels().keySet();
        }
        catch (Exception e) {
            labels = Collections.emptySet();
        }
        return new ExcludingValueValidator(labels, "Project already contains a session named %s.", isStrict);
    }

    private boolean isOkToProceed() {
        if (this.sessionDate == null || !this.isSessionDateOk(this.confirmedDate, this.sessionDate, this.session.getTimeZone())) {
            return false;
        }
        SessionVariable userSessionLabelContainer = (SessionVariable)this.getWizardData("session");
        String userSessionLabel = userSessionLabelContainer.getValue();
        if (this.sessionLabel == null && StringUtils.isBlank((String)userSessionLabel)) {
            return false;
        }
        boolean stop = this.stopForDuplicateSessionId(userSessionLabel, true);
        AutoArchive autoArchive = null;
        if (stop) {
            autoArchive = (AutoArchive)this.getWizardData("autoArchive");
        }
        return !stop || autoArchive != null;
    }
}

